<?php
/**
 * CodeIgniter 3.1.13 index.php for PHP 8.2+
 */

// ------------------------------------------------------
//  ENVIRONMENT
// ------------------------------------------------------
define('ENVIRONMENT', 'development'); // 'development', 'testing', 'production'

// ------------------------------------------------------
//  SYSTEM FOLDER NAME
// ------------------------------------------------------
$system_path = 'system';

// ------------------------------------------------------
//  APPLICATION FOLDER NAME
// ------------------------------------------------------
$application_folder = 'application';

// ------------------------------------------------------
//  Resolve the system path for increased reliability
// ------------------------------------------------------
if (($_temp = realpath($system_path)) !== FALSE) {
    $system_path = $_temp . DIRECTORY_SEPARATOR;
} else {
    $system_path = rtrim($system_path, '/\\') . DIRECTORY_SEPARATOR;
}

// ------------------------------------------------------
//  Set main path constants
// ------------------------------------------------------
define('BASEPATH', str_replace('\\', '/', $system_path));

if (is_dir($application_folder)) {
    define('APPPATH', $application_folder . DIRECTORY_SEPARATOR);
} else {
    if (!is_dir(BASEPATH . $application_folder . DIRECTORY_SEPARATOR)) {
        exit("Your application folder path is incorrect: $application_folder");
    }
    define('APPPATH', BASEPATH . $application_folder . DIRECTORY_SEPARATOR);
}

// Front controller path
define('FCPATH', __DIR__ . DIRECTORY_SEPARATOR);

// View folder path
define('VIEWPATH', APPPATH . 'views' . DIRECTORY_SEPARATOR);

// ------------------------------------------------------
//  Load the bootstrap file
// ------------------------------------------------------
require_once BASEPATH . 'core/CodeIgniter.php';
