import { useState } from 'react';
import Layout from '@/components/Layout';
import ScrollReveal from '@/components/ScrollReveal';
import ProjectCard from '@/components/ProjectCard';

const allProjects = [
  {
    title: 'The Art of Motion',
    category: 'Brand Film',
    image: 'https://images.unsplash.com/photo-1536440136628-849c177e76a1?w=800&q=80',
    slug: 'art-of-motion',
  },
  {
    title: 'Urban Horizons',
    category: 'Documentary',
    image: 'https://images.unsplash.com/photo-1485846234645-a62644f84728?w=800&q=80',
    slug: 'urban-horizons',
  },
  {
    title: 'Essence of Light',
    category: 'Commercial',
    image: 'https://images.unsplash.com/photo-1518676590629-3dcbd9c5a5c9?w=800&q=80',
    slug: 'essence-of-light',
  },
  {
    title: 'Beyond Boundaries',
    category: 'Music Video',
    image: 'https://images.unsplash.com/photo-1574717024653-61fd2cf4d44d?w=800&q=80',
    slug: 'beyond-boundaries',
  },
  {
    title: 'Silent Stories',
    category: 'Short Film',
    image: 'https://images.unsplash.com/photo-1492691527719-9d1e07e534b4?w=800&q=80',
    slug: 'silent-stories',
  },
  {
    title: 'Neon Dreams',
    category: 'Fashion Film',
    image: 'https://images.unsplash.com/photo-1516035069371-29a1b244cc32?w=800&q=80',
    slug: 'neon-dreams',
  },
  {
    title: 'The Wanderer',
    category: 'Documentary',
    image: 'https://images.unsplash.com/photo-1440404653325-ab127d49abc1?w=800&q=80',
    slug: 'the-wanderer',
  },
  {
    title: 'Midnight Pulse',
    category: 'Music Video',
    image: 'https://images.unsplash.com/photo-1493225457124-a3eb161ffa5f?w=800&q=80',
    slug: 'midnight-pulse',
  },
  {
    title: 'Pure Elegance',
    category: 'Commercial',
    image: 'https://images.unsplash.com/photo-1505236858219-8359eb29e329?w=800&q=80',
    slug: 'pure-elegance',
  },
];

const categories = ['All', 'Brand Film', 'Documentary', 'Commercial', 'Music Video', 'Short Film', 'Fashion Film'];

const Work = () => {
  const [activeCategory, setActiveCategory] = useState('All');

  const filteredProjects = activeCategory === 'All'
    ? allProjects
    : allProjects.filter(project => project.category === activeCategory);

  return (
    <Layout>
      {/* Hero Section */}
      <section className="pt-32 pb-16 md:pt-40 md:pb-24 bg-background">
        <div className="container mx-auto px-6">
          <div className="max-w-4xl">
            <ScrollReveal>
              <p className="text-xs uppercase tracking-[0.3em] text-muted-foreground mb-4">
                Our Portfolio
              </p>
            </ScrollReveal>
            <ScrollReveal delay={100}>
              <h1 className="text-5xl md:text-6xl lg:text-7xl font-light mb-6">
                Selected Work
              </h1>
            </ScrollReveal>
            <ScrollReveal delay={200}>
              <p className="text-lg text-muted-foreground max-w-2xl">
                A curated collection of our finest productions, showcasing our expertise
                in visual storytelling across various genres and formats.
              </p>
            </ScrollReveal>
          </div>
        </div>
      </section>

      {/* Filter Section */}
      <section className="py-8 border-y border-border bg-background sticky top-20 z-30">
        <div className="container mx-auto px-6">
          <div className="flex items-center gap-6 overflow-x-auto pb-2 scrollbar-hide">
            {categories.map((category) => (
              <button
                key={category}
                onClick={() => setActiveCategory(category)}
                className={`text-sm uppercase tracking-wider whitespace-nowrap transition-all duration-300 ${
                  activeCategory === category
                    ? 'text-foreground'
                    : 'text-muted-foreground hover:text-foreground'
                }`}
              >
                {category}
                {activeCategory === category && (
                  <span className="block h-px w-full bg-foreground mt-1" />
                )}
              </button>
            ))}
          </div>
        </div>
      </section>

      {/* Projects Grid */}
      <section className="py-16 md:py-24 bg-background">
        <div className="container mx-auto px-6">
          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8 md:gap-12">
            {filteredProjects.map((project, index) => (
              <ScrollReveal key={project.slug} delay={index * 100}>
                <ProjectCard {...project} index={index} />
              </ScrollReveal>
            ))}
          </div>

          {filteredProjects.length === 0 && (
            <div className="text-center py-16">
              <p className="text-muted-foreground">No projects found in this category.</p>
            </div>
          )}
        </div>
      </section>
    </Layout>
  );
};

export default Work;
