import Layout from '@/components/Layout';
import ScrollReveal from '@/components/ScrollReveal';

const clients = [
  { name: 'Nike', logo: 'NIKE' },
  { name: 'Apple', logo: 'APPLE' },
  { name: 'Google', logo: 'GOOGLE' },
  { name: 'Amazon', logo: 'AMAZON' },
  { name: 'Netflix', logo: 'NETFLIX' },
  { name: 'Spotify', logo: 'SPOTIFY' },
  { name: 'Adobe', logo: 'ADOBE' },
  { name: 'Meta', logo: 'META' },
  { name: 'Microsoft', logo: 'MICROSOFT' },
  { name: 'Tesla', logo: 'TESLA' },
  { name: 'Sony', logo: 'SONY' },
  { name: 'Samsung', logo: 'SAMSUNG' },
  { name: 'BMW', logo: 'BMW' },
  { name: 'Audi', logo: 'AUDI' },
  { name: 'Porsche', logo: 'PORSCHE' },
  { name: 'Louis Vuitton', logo: 'LV' },
];

const testimonials = [
  {
    quote: "Go Productions delivered beyond our expectations. Their creative vision and attention to detail transformed our brand story into something truly remarkable.",
    author: 'Sarah Chen',
    role: 'Marketing Director',
    company: 'Tech Innovations',
  },
  {
    quote: "Working with the Go Productions team was an absolute pleasure. They understood our vision from day one and executed it flawlessly.",
    author: 'Michael Foster',
    role: 'Brand Manager',
    company: 'Global Lifestyle Co.',
  },
  {
    quote: "The professionalism and creativity of Go Productions is unmatched. They've become our go-to production partner for all our video content.",
    author: 'Priya Malhotra',
    role: 'CEO',
    company: 'Luxe Brands',
  },
];

const Clients = () => {
  return (
    <Layout>
      {/* Hero Section */}
      <section className="pt-32 pb-16 md:pt-40 md:pb-24 bg-background">
        <div className="container mx-auto px-6">
          <div className="max-w-4xl">
            <ScrollReveal>
              <p className="text-xs uppercase tracking-[0.3em] text-muted-foreground mb-4">
                Our Clients
              </p>
            </ScrollReveal>
            <ScrollReveal delay={100}>
              <h1 className="text-5xl md:text-6xl lg:text-7xl font-light mb-6">
                Trusted by Leading Brands
              </h1>
            </ScrollReveal>
            <ScrollReveal delay={200}>
              <p className="text-lg text-muted-foreground max-w-2xl">
                We've had the privilege of collaborating with some of the world's most 
                iconic brands, helping them tell their stories through powerful visual content.
              </p>
            </ScrollReveal>
          </div>
        </div>
      </section>

      {/* Clients Grid */}
      <section className="py-16 md:py-24 bg-secondary">
        <div className="container mx-auto px-6">
          <div className="grid grid-cols-2 md:grid-cols-4 gap-px bg-border">
            {clients.map((client, index) => (
              <ScrollReveal key={client.name} delay={index * 50}>
                <div className="bg-secondary p-8 md:p-12 flex items-center justify-center aspect-square hover:bg-foreground hover:text-background transition-all duration-500 group">
                  <span className="text-xl md:text-2xl font-light tracking-widest text-muted-foreground group-hover:text-background transition-colors duration-500">
                    {client.logo}
                  </span>
                </div>
              </ScrollReveal>
            ))}
          </div>
        </div>
      </section>

      {/* Testimonials Section */}
      <section className="py-24 md:py-32 bg-background">
        <div className="container mx-auto px-6">
          <ScrollReveal>
            <div className="text-center mb-16">
              <p className="text-xs uppercase tracking-[0.3em] text-muted-foreground mb-4">
                Testimonials
              </p>
              <h2 className="text-4xl md:text-5xl font-light">What They Say</h2>
            </div>
          </ScrollReveal>

          <div className="grid grid-cols-1 md:grid-cols-3 gap-8 md:gap-12">
            {testimonials.map((testimonial, index) => (
              <ScrollReveal key={testimonial.author} delay={index * 150}>
                <div className="border border-border p-8 md:p-10 h-full flex flex-col">
                  <blockquote className="text-lg font-light leading-relaxed mb-8 flex-1">
                    "{testimonial.quote}"
                  </blockquote>
                  <div>
                    <p className="font-medium">{testimonial.author}</p>
                    <p className="text-sm text-muted-foreground">
                      {testimonial.role}, {testimonial.company}
                    </p>
                  </div>
                </div>
              </ScrollReveal>
            ))}
          </div>
        </div>
      </section>

      {/* Partnership Section */}
      <section className="py-24 md:py-32 bg-foreground text-background">
        <div className="container mx-auto px-6">
          <ScrollReveal>
            <div className="max-w-4xl mx-auto text-center">
              <h2 className="text-4xl md:text-5xl font-light mb-8">
                Join Our Growing List of Partners
              </h2>
              <p className="text-lg text-background/70 mb-12 max-w-2xl mx-auto">
                Whether you're a global brand or an emerging business, we're here to help 
                you create visual content that makes an impact.
              </p>
              <a
                href="/contact"
                className="inline-flex items-center gap-2 bg-background text-foreground px-8 py-4 text-sm uppercase tracking-wider hover:bg-background/90 transition-all duration-300"
              >
                Become a Client
              </a>
            </div>
          </ScrollReveal>
        </div>
      </section>
    </Layout>
  );
};

export default Clients;
