import { ArrowRight } from 'lucide-react';
import { Link } from 'react-router-dom';
import Layout from '@/components/Layout';
import ScrollReveal from '@/components/ScrollReveal';

const About = () => {
  const stats = [
    { number: '150+', label: 'Projects Completed' },
    { number: '50+', label: 'Global Clients' },
    { number: '10+', label: 'Years Experience' },
    { number: '25+', label: 'Award Wins' },
  ];

  const team = [
    {
      name: 'Rahul Sharma',
      role: 'Founder & Creative Director',
      image: 'https://images.unsplash.com/photo-1507003211169-0a1dd7228f2d?w=400&q=80',
    },
    {
      name: 'Priya Kapoor',
      role: 'Executive Producer',
      image: 'https://images.unsplash.com/photo-1494790108377-be9c29b29330?w=400&q=80',
    },
    {
      name: 'Arjun Mehta',
      role: 'Director of Photography',
      image: 'https://images.unsplash.com/photo-1472099645785-5658abf4ff4e?w=400&q=80',
    },
    {
      name: 'Ananya Singh',
      role: 'Post Production Head',
      image: 'https://images.unsplash.com/photo-1438761681033-6461ffad8d80?w=400&q=80',
    },
  ];

  return (
    <Layout>
      {/* Hero Section */}
      <section className="pt-32 pb-16 md:pt-40 md:pb-24 bg-background">
        <div className="container mx-auto px-6">
          <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 lg:gap-24 items-center">
            <div>
              <ScrollReveal>
                <p className="text-xs uppercase tracking-[0.3em] text-muted-foreground mb-4">
                  About Us
                </p>
              </ScrollReveal>
              <ScrollReveal delay={100}>
                <h1 className="text-5xl md:text-6xl lg:text-7xl font-light mb-6">
                  Crafting Visual Excellence
                </h1>
              </ScrollReveal>
              <ScrollReveal delay={200}>
                <p className="text-lg text-muted-foreground leading-relaxed">
                  Go Productions is a premier film and video production company based in 
                  New Delhi, India. We specialize in creating compelling visual narratives 
                  that resonate with audiences and elevate brands to new heights.
                </p>
              </ScrollReveal>
            </div>
            <ScrollReveal delay={300}>
              <div className="relative">
                <img
                  src="https://images.unsplash.com/photo-1540655037529-dec987208707?w=800&q=80"
                  alt="Production"
                  className="w-full aspect-[4/5] object-cover"
                />
                <div className="absolute -bottom-6 -left-6 w-32 h-32 border border-foreground" />
              </div>
            </ScrollReveal>
          </div>
        </div>
      </section>

      {/* Stats Section */}
      <section className="py-16 md:py-24 bg-foreground text-background">
        <div className="container mx-auto px-6">
          <div className="grid grid-cols-2 md:grid-cols-4 gap-8 md:gap-12">
            {stats.map((stat, index) => (
              <ScrollReveal key={stat.label} delay={index * 100}>
                <div className="text-center">
                  <span className="text-4xl md:text-5xl lg:text-6xl font-light block mb-2">
                    {stat.number}
                  </span>
                  <span className="text-sm uppercase tracking-wider text-background/60">
                    {stat.label}
                  </span>
                </div>
              </ScrollReveal>
            ))}
          </div>
        </div>
      </section>

      {/* Story Section */}
      <section className="py-24 md:py-32 bg-background">
        <div className="container mx-auto px-6">
          <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 lg:gap-24">
            <div>
              <ScrollReveal>
                <p className="text-xs uppercase tracking-[0.3em] text-muted-foreground mb-4">
                  Our Story
                </p>
              </ScrollReveal>
              <ScrollReveal delay={100}>
                <h2 className="text-4xl md:text-5xl font-light mb-8">
                  A Decade of Visual Storytelling
                </h2>
              </ScrollReveal>
            </div>
            <div className="space-y-6">
              <ScrollReveal delay={200}>
                <p className="text-muted-foreground leading-relaxed">
                  Founded in 2014, Go Productions emerged from a passion for creating 
                  meaningful visual content that moves people. What started as a small 
                  team of filmmakers has grown into a full-service production house 
                  serving clients across the globe.
                </p>
              </ScrollReveal>
              <ScrollReveal delay={300}>
                <p className="text-muted-foreground leading-relaxed">
                  Our approach combines artistic vision with technical precision. We believe 
                  every brand has a unique story waiting to be told, and our mission is to 
                  bring those stories to life through the power of cinema.
                </p>
              </ScrollReveal>
              <ScrollReveal delay={400}>
                <p className="text-muted-foreground leading-relaxed">
                  From commercials to documentaries, music videos to brand films, we've 
                  had the privilege of working with some of the most innovative brands 
                  and talented artists in the industry.
                </p>
              </ScrollReveal>
            </div>
          </div>
        </div>
      </section>

      {/* Approach Section */}
      <section className="py-24 md:py-32 bg-secondary">
        <div className="container mx-auto px-6">
          <ScrollReveal>
            <div className="text-center mb-16">
              <p className="text-xs uppercase tracking-[0.3em] text-muted-foreground mb-4">
                Our Approach
              </p>
              <h2 className="text-4xl md:text-5xl font-light">How We Work</h2>
            </div>
          </ScrollReveal>

          <div className="grid grid-cols-1 md:grid-cols-3 gap-8 md:gap-12">
            {[
              {
                step: '01',
                title: 'Discover',
                desc: 'We dive deep into understanding your brand, audience, and objectives to craft a strategic creative direction.',
              },
              {
                step: '02',
                title: 'Create',
                desc: 'Our team brings the vision to life through meticulous pre-production planning and flawless execution.',
              },
              {
                step: '03',
                title: 'Deliver',
                desc: 'We refine every frame in post-production, ensuring the final product exceeds expectations.',
              },
            ].map((item, index) => (
              <ScrollReveal key={item.step} delay={index * 150}>
                <div className="relative">
                  <span className="text-8xl font-light text-muted-foreground/20 absolute -top-8 -left-4">
                    {item.step}
                  </span>
                  <div className="relative pt-16">
                    <h3 className="text-2xl font-light mb-4">{item.title}</h3>
                    <p className="text-muted-foreground leading-relaxed">{item.desc}</p>
                  </div>
                </div>
              </ScrollReveal>
            ))}
          </div>
        </div>
      </section>

      {/* Team Section */}
      <section className="py-24 md:py-32 bg-background">
        <div className="container mx-auto px-6">
          <ScrollReveal>
            <div className="text-center mb-16">
              <p className="text-xs uppercase tracking-[0.3em] text-muted-foreground mb-4">
                The Team
              </p>
              <h2 className="text-4xl md:text-5xl font-light">Meet Our Creatives</h2>
            </div>
          </ScrollReveal>

          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
            {team.map((member, index) => (
              <ScrollReveal key={member.name} delay={index * 100}>
                <div className="group">
                  <div className="relative overflow-hidden mb-4">
                    <img
                      src={member.image}
                      alt={member.name}
                      className="w-full aspect-[3/4] object-cover grayscale group-hover:grayscale-0 transition-all duration-500"
                    />
                  </div>
                  <h3 className="text-lg font-light mb-1">{member.name}</h3>
                  <p className="text-sm text-muted-foreground">{member.role}</p>
                </div>
              </ScrollReveal>
            ))}
          </div>
        </div>
      </section>

      {/* CTA Section */}
      <section className="py-24 md:py-32 bg-foreground text-background">
        <div className="container mx-auto px-6">
          <ScrollReveal>
            <div className="max-w-3xl mx-auto text-center">
              <h2 className="text-4xl md:text-5xl font-light mb-8">
                Ready to create something amazing?
              </h2>
              <p className="text-lg text-background/70 mb-12">
                We'd love to hear about your project and explore how we can bring your vision to life.
              </p>
              <Link
                to="/contact"
                className="inline-flex items-center gap-2 bg-background text-foreground px-8 py-4 text-sm uppercase tracking-wider hover:bg-background/90 transition-all duration-300"
              >
                Start a Conversation
                <ArrowRight className="w-4 h-4" />
              </Link>
            </div>
          </ScrollReveal>
        </div>
      </section>
    </Layout>
  );
};

export default About;
