import { Link } from 'react-router-dom';

interface ProjectCardProps {
  title: string;
  category: string;
  image: string;
  slug: string;
  index?: number;
}

const ProjectCard = ({ title, category, image, slug, index = 0 }: ProjectCardProps) => {
  return (
    <Link
      to={`/work/${slug}`}
      className="group block relative overflow-hidden"
      data-cursor="view"
      style={{
        animationDelay: `${index * 0.1}s`,
      }}
    >
      {/* Image Container */}
      <div className="relative aspect-[4/5] overflow-hidden bg-muted">
        <img
          src={image}
          alt={title}
          className="w-full h-full object-cover transition-transform duration-700 ease-out group-hover:scale-110"
        />
        
        {/* Overlay */}
        <div className="absolute inset-0 bg-foreground/0 group-hover:bg-foreground/20 transition-all duration-500" />
      </div>

      {/* Info */}
      <div className="mt-4 space-y-1">
        <p className="text-xs uppercase tracking-wider text-muted-foreground">
          {category}
        </p>
        <h3 className="text-lg font-light tracking-wide group-hover:tracking-wider transition-all duration-300">
          {title}
        </h3>
      </div>

      {/* Animated Line */}
      <div className="absolute bottom-0 left-0 h-px w-0 bg-foreground group-hover:w-full transition-all duration-500" />
    </Link>
  );
};

export default ProjectCard;
