import { Link } from 'react-router-dom';
import { Instagram, Linkedin, Youtube, Mail, Phone, MapPin } from 'lucide-react';
import logo from '@/assets/logo.png';

const Footer = () => {
  const currentYear = new Date().getFullYear();

  const quickLinks = [
    { name: 'Work', path: '/work' },
    { name: 'About', path: '/about' },
    { name: 'Clients', path: '/clients' },
    { name: 'Contact', path: '/contact' },
  ];

  const socialLinks = [
    { icon: Instagram, href: 'https://instagram.com', label: 'Instagram' },
    { icon: Linkedin, href: 'https://linkedin.com', label: 'LinkedIn' },
    { icon: Youtube, href: 'https://youtube.com', label: 'YouTube' },
  ];

  const marqueeText = 'FILM PRODUCTION • CINEMATOGRAPHY • CREATIVE DIRECTION • POST PRODUCTION • COLOR GRADING • HIGH-END RETOUCHING • VISUAL EFFECTS • ';

  return (
    <footer className="bg-foreground text-background">
      {/* Main Footer Content */}
      <div className="container mx-auto px-6 py-16 md:py-24">
        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-12 md:gap-8">
          {/* Logo & About */}
          <div className="lg:col-span-2">
            <Link to="/">
              <img
                src={logo}
                alt="Go Productions"
                className="h-12 w-auto mb-6 invert"
              />
            </Link>
            <p className="text-background/70 max-w-md leading-relaxed">
              We are a premium film and video production company based in Delhi, 
              specializing in creating compelling visual stories for brands worldwide.
            </p>
          </div>

          {/* Quick Links */}
          <div>
            <h4 className="text-sm uppercase tracking-wider mb-6 font-medium">
              Quick Links
            </h4>
            <ul className="space-y-4">
              {quickLinks.map((link) => (
                <li key={link.path}>
                  <Link
                    to={link.path}
                    className="text-background/70 hover:text-background transition-colors duration-300"
                  >
                    {link.name}
                  </Link>
                </li>
              ))}
            </ul>
          </div>

          {/* Contact Info */}
          <div>
            <h4 className="text-sm uppercase tracking-wider mb-6 font-medium">
              Contact
            </h4>
            <ul className="space-y-4">
              <li>
                <a
                  href="mailto:info@goproductions.in"
                  className="flex items-center gap-3 text-background/70 hover:text-background transition-colors duration-300"
                >
                  <Mail className="w-4 h-4" />
                  info@goproductions.in
                </a>
              </li>
              <li>
                <a
                  href="tel:+919876543210"
                  className="flex items-center gap-3 text-background/70 hover:text-background transition-colors duration-300"
                >
                  <Phone className="w-4 h-4" />
                  +91 98765 43210
                </a>
              </li>
              <li>
                <div className="flex items-start gap-3 text-background/70">
                  <MapPin className="w-4 h-4 mt-1 flex-shrink-0" />
                  <span>
                    Silver Oak Farms,<br />
                    New Delhi, India
                  </span>
                </div>
              </li>
            </ul>

            {/* Social Links */}
            <div className="flex items-center gap-4 mt-8">
              {socialLinks.map((social) => (
                <a
                  key={social.label}
                  href={social.href}
                  target="_blank"
                  rel="noopener noreferrer"
                  className="w-10 h-10 rounded-full border border-background/30 flex items-center justify-center hover:bg-background hover:text-foreground transition-all duration-300"
                  aria-label={social.label}
                >
                  <social.icon className="w-4 h-4" />
                </a>
              ))}
            </div>
          </div>
        </div>
      </div>

      {/* Marquee */}
      <div className="border-t border-background/10 overflow-hidden py-6">
        <div className="animate-marquee whitespace-nowrap flex">
          <span className="text-sm tracking-[0.3em] text-background/30 mx-4">
            {marqueeText}
          </span>
          <span className="text-sm tracking-[0.3em] text-background/30 mx-4">
            {marqueeText}
          </span>
          <span className="text-sm tracking-[0.3em] text-background/30 mx-4">
            {marqueeText}
          </span>
          <span className="text-sm tracking-[0.3em] text-background/30 mx-4">
            {marqueeText}
          </span>
        </div>
      </div>

      {/* Copyright */}
      <div className="border-t border-background/10 py-6">
        <div className="container mx-auto px-6 flex flex-col md:flex-row items-center justify-between gap-4">
          <p className="text-sm text-background/50">
            © {currentYear} Go Productions. All rights reserved.
          </p>
          <p className="text-sm text-background/50">
            Crafted with passion in Delhi, India
          </p>
        </div>
      </div>
    </footer>
  );
};

export default Footer;
