USE productions_db;

-- Add SEO and Project Detail fields to projects table
ALTER TABLE projects 
ADD COLUMN IF NOT EXISTS meta_title VARCHAR(255),
ADD COLUMN IF NOT EXISTS meta_description TEXT,
ADD COLUMN IF NOT EXISTS js_schema TEXT,
ADD COLUMN IF NOT EXISTS seo_slug VARCHAR(255),
ADD COLUMN IF NOT EXISTS project_url VARCHAR(255),
ADD COLUMN IF NOT EXISTS shoot_date DATE,
ADD COLUMN IF NOT EXISTS model_name VARCHAR(255);

-- Create Homepage Layout table
CREATE TABLE IF NOT EXISTS homepage_layout (
    id INT AUTO_INCREMENT PRIMARY KEY,
    project_id INT NOT NULL,
    x_pos INT DEFAULT 0,
    y_pos INT DEFAULT 0,
    width INT DEFAULT 300,
    height INT DEFAULT 400,
    z_index INT DEFAULT 1,
    is_custom TINYINT DEFAULT 1,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (project_id) REFERENCES projects(id) ON DELETE CASCADE
);
