<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta name="description" content="Go Productions - Premium film & video production company">
  <title><?php echo isset($title) ? $title . ' - Go Productions' : (isset($project->title) ? $project->title . ' - Go Productions' : 'Go Productions - Premium Film & Video Production'); ?></title>
  
  <!-- Google Fonts -->
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500&display=swap" rel="stylesheet">
  
  <!-- Lucide Icons -->
  <script src="https://unpkg.com/lucide@latest/dist/umd/lucide.min.js"></script>
  
  <!-- Styles -->
  <link rel="stylesheet" href="<?php echo base_url('assets/css/main.css?v=1.1'); ?>">
  
  <!-- Favicon -->
  <link rel="icon" href="<?php echo base_url('assets/logo.png'); ?>" type="image/png">
</head>
<body>
  
  <!-- Header -->
  <header class="logo-reveal">
    <div class="container">
      <a href="<?php echo base_url(); ?>">
        <img src="<?php echo base_url('assets/logo.png'); ?>" alt="Go Productions" class="logo">
      </a>
      
      <nav>
        <a href="<?php echo base_url(); ?>" class="<?php echo (!isset($page) || $page == 'work') ? 'active' : ''; ?>">Work</a>
      
        <a href="<?php echo base_url('Portfolio/about'); ?>" class="<?php echo (isset($page) && $page == 'about') ? 'active' : ''; ?>">About</a>
        <a href="<?php echo base_url('Portfolio/clients'); ?>" class="<?php echo (isset($page) && $page == 'clients') ? 'active' : ''; ?>">Clients</a>
        <a href="<?php echo base_url('Portfolio/contact'); ?>" class="<?php echo (isset($page) && $page == 'contact') ? 'active' : ''; ?>">Contact</a>
      </nav>
      
      <button class="mobile-menu-btn" aria-label="Toggle menu">
        <span></span>
        <span></span>
        <span></span>
      </button>
    </div>
  </header>
  
  <!-- Mobile Menu -->
  <div class="mobile-menu">
    <nav>
      <a href="<?php echo base_url(); ?>">Home</a>
      <a href="<?php echo base_url('Portfolio/work'); ?>">Work</a>
      <a href="<?php echo base_url('Portfolio/about'); ?>">About</a>
      <a href="<?php echo base_url('Portfolio/clients'); ?>">Clients</a>
      <a href="<?php echo base_url('Portfolio/contact'); ?>">Contact</a>
    </nav>
  </div>