  <?php
    $CI =& get_instance();
    $CI->load->model('Contact_model');
    $contact = $CI->Contact_model->get_contact_settings();
  ?>
  
  <!-- Footer -->
  <footer>
    <div class="container">
      <div class="footer-content">
        <!-- Logo & About -->
        <div>
          <a href="<?php echo base_url(); ?>">
            <img src="<?php echo base_url('assets/logo.png'); ?>" alt="Go Productions" class="logo">
          </a>
          <p style="color: rgba(255, 255, 255, 0.7); line-height: 1.8; max-width: 400px;">
            We are a premium film and video production company based in Delhi, 
            specializing in creating compelling visual stories for brands worldwide.
          </p>
        </div>
        
        <!-- Quick Links -->
        <div>
          <h4>Quick Links</h4>
          <ul>
            <li><a href="<?php echo base_url(); ?>">Work</a></li>
            <li><a href="<?php echo base_url('portfolio/about'); ?>">About</a></li>
            <li><a href="<?php echo base_url('portfolio/clients'); ?>">Clients</a></li>
            <li><a href="<?php echo base_url('portfolio/contact'); ?>">Contact</a></li>
          </ul>
        </div>
        
        <!-- Contact -->
        <div>
          <h4>Contact</h4>
          <ul>
            <?php if(!empty($contact->email)): ?>
            <li>
              <a href="mailto:<?php echo $contact->email; ?>">
                <i data-lucide="mail" style="width: 16px; height: 16px;"></i> <?php echo $contact->email; ?>
              </a>
            </li>
            <?php endif; ?>
            <?php if(!empty($contact->phone)): ?>
            <li>
              <a href="tel:<?php echo $contact->phone; ?>">
                <i data-lucide="phone" style="width: 16px; height: 16px;"></i> <?php echo $contact->phone; ?>
              </a>
            </li>
            <?php endif; ?>
            <?php if(!empty($contact->address)): ?>
            <li style="display: flex; align-items: start; gap: 0.75rem;">
              <i data-lucide="map-pin" style="width: 16px; height: 16px; margin-top: 4px; color: rgba(255, 255, 255, 0.7);"></i>
              <span style="color: rgba(255, 255, 255, 0.7);">
                <?php echo nl2br($contact->address); ?>
              </span>
            </li>
            <?php endif; ?>
          </ul>
          
          <div class="social-links">
            <a href="https://www.instagram.com/goproductions.in?igsh=MWwwd3M0ZnJ5aHhmZA==" target="_blank" aria-label="Instagram">
              <i data-lucide="instagram" style="width: 16px; height: 16px;"></i>
            </a>
            <a href="https://www.linkedin.com/company/goproductions/" target="_blank" aria-label="LinkedIn">
              <i data-lucide="linkedin" style="width: 16px; height: 16px;"></i>
            </a>
            <a href="https://www.behance.net/gostudioproductions" target="_blank" aria-label="Behance">
              <!-- Behance Icon substitution (Lucide doesn't have Behance, using Globe/Image as fallback or FontAwesome if available, but staying consistent with Lucide for now, maybe use Link icon or just text? User used Lucide previously. I will check if Lucide has Behance. It usually doesn't. I'll use 'globe' or 'image' or just keep the structure. Wait, I should check if FontAwesome is available. -->
              <i data-lucide="globe" style="width: 16px; height: 16px;"></i>
            </a>
          </div>
        </div>
      </div>
      
      <!-- Marquee -->
      <div class="marquee">
        <div class="marquee-content">
          <span class="marquee-text">FILM PRODUCTION • CINEMATOGRAPHY • CREATIVE DIRECTION • POST PRODUCTION • COLOR GRADING • HIGH-END RETOUCHING • VISUAL EFFECTS • </span>
          <span class="marquee-text">FILM PRODUCTION • CINEMATOGRAPHY • CREATIVE DIRECTION • POST PRODUCTION • COLOR GRADING • HIGH-END RETOUCHING • VISUAL EFFECTS • </span>
          <span class="marquee-text">FILM PRODUCTION • CINEMATOGRAPHY • CREATIVE DIRECTION • POST PRODUCTION • COLOR GRADING • HIGH-END RETOUCHING • VISUAL EFFECTS • </span>
          <span class="marquee-text">FILM PRODUCTION • CINEMATOGRAPHY • CREATIVE DIRECTION • POST PRODUCTION • COLOR GRADING • HIGH-END RETOUCHING • VISUAL EFFECTS • </span>
        </div>
      </div>
      
      <!-- Copyright -->
      <div class="copyright">
        <p>&copy; <?php echo date('Y'); ?> Go Productions. All rights reserved.</p>
        <p>Crafted with passion in Delhi, India</p>
      </div>
    </div>
  </footer>
  
  <!-- Scripts -->
  <script src="<?php echo base_url('assets/js/main.js?v=1.1'); ?>"></script>
  <script>
    // Initialize Lucide icons
    if (typeof lucide !== 'undefined') {
      lucide.createIcons();
    }
  </script>
</body>
</html>
