<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $project->title; ?> - GO PRODUCTIONS</title>
    <style>
        /* Add similar styles as your existing project detail page */
        .cover-display {
            width: 100%;
            height: 60vh;
            max-height: 800px;
            position: relative;
            background: #f5f5f5;
            overflow: hidden;
            border-radius: 12px;
            margin-bottom: 3rem;
        }
        
        .cover-element {
            position: absolute;
            transform-origin: center;
            border-radius: 8px;
            overflow: hidden;
            box-shadow: 0 5px 20px rgba(0,0,0,0.1);
        }
        
        .cover-element img,
        .cover-element video {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }
        
        .project-info {
            max-width: 800px;
            margin: 0 auto 3rem;
            padding: 2rem;
            background: white;
            border-radius: 12px;
            box-shadow: 0 2px 20px rgba(0,0,0,0.05);
        }
        
        .project-description {
            font-size: 1.1rem;
            line-height: 1.6;
            color: #555;
            margin-top: 1rem;
        }
        
        .files-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
            gap: 2rem;
            margin-top: 3rem;
        }
        
        .file-item {
            background: white;
            border-radius: 12px;
            overflow: hidden;
            box-shadow: 0 5px 15px rgba(0,0,0,0.08);
            transition: transform 0.3s;
        }
        
        .file-item:hover {
            transform: translateY(-5px);
        }
    </style>
</head>
<body>
    <!-- Your existing navigation -->
    
    <main>
        <div class="container">
            <div class="cover-display" id="coverDisplay">
                <!-- Cover layout will be rendered here -->
            </div>
            
            <div class="project-info">
                <h1><?php echo $project->title; ?></h1>
                <div class="project-meta">
                    <strong>Client:</strong> <?php echo $project->client_name; ?>
                    <?php if (!empty($project->model_name)): ?>
                         | <strong>Model:</strong> <?php echo $project->model_name; ?>
                    <?php endif; ?>
                    <?php if (!empty($project->shoot_date) && $project->shoot_date != '0000-00-00'): ?>
                         | <strong>Date:</strong> <?php echo date('F Y', strtotime($project->shoot_date)); ?>
                    <?php endif; ?>
                </div>
                
                <?php if (!empty($project->description)): ?>
                    <div class="project-description">
                        <?php echo nl2br($project->description); ?>
                    </div>
                <?php endif; ?>
            </div>
            
            <?php if (!empty($project_files)): ?>
                <div class="files-grid">
                    <?php foreach ($project_files as $file): ?>
                        <div class="file-item">
                            <?php if ($file->file_type == 'image'): ?>
                                <img src="<?php echo base_url($file->file_path); ?>" alt="Project File">
                            <?php elseif ($file->file_type == 'video'): ?>
                                <video controls style="width: 100%;">
                                    <source src="<?php echo base_url($file->file_path); ?>" type="video/mp4">
                                </video>
                            <?php else: ?>
                                <div style="padding: 2rem; text-align: center; background: #f8f9fa;">
                                    <div style="font-size: 3rem;">📄</div>
                                    <div>Document</div>
                                </div>
                            <?php endif; ?>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        </div>
    </main>

    <script>
        // Render cover layout
        document.addEventListener('DOMContentLoaded', function() {
            <?php if (!empty($project->cover_layout)): ?>
                const layout = JSON.parse('<?php echo addslashes($project->cover_layout); ?>');
                const coverDisplay = document.getElementById('coverDisplay');
                
                layout.forEach(item => {
                    const element = document.createElement('div');
                    element.className = 'cover-element';
                    element.style.left = item.x + 'px';
                    element.style.top = item.y + 'px';
                    element.style.width = item.width + 'px';
                    element.style.height = item.height + 'px';
                    element.style.transform = `rotate(${item.rotation}deg)`;
                    element.style.zIndex = item.zIndex;
                    
                    if (item.type === 'image') {
                        const img = document.createElement('img');
                        img.src = item.src;
                        img.alt = 'Cover element';
                        element.appendChild(img);
                    } else if (item.type === 'video') {
                        const video = document.createElement('video');
                        video.src = item.src;
                        video.autoplay = true;
                        video.muted = true;
                        video.loop = true;
                        video.playsInline = true;
                        element.appendChild(video);
                    } else {
                        element.style.background = '#007bff';
                        element.style.display = 'flex';
                        element.style.alignItems = 'center';
                        element.style.justifyContent = 'center';
                        element.style.color = 'white';
                        element.innerHTML = '<div style="font-size: 2rem;">📄</div>';
                    }
                    
                    coverDisplay.appendChild(element);
                });
            <?php endif; ?>
        });
    </script>
</body>
</html>