<?php $this->load->view('templates/header'); ?>

    <style>
        :root {
            --primary: #000;
            --text-main: #1a1a1a;
            --text-light: #666;
            --bg: #ffffff;
        }

        body {
            font-family: 'Inter', sans-serif;
            background: var(--bg);
            color: var(--text-main);
            line-height: 1.6;
            overflow-x: hidden;
        }

        /* Main Content */
        main {
            padding-top: 120px;
            padding-bottom: 5rem;
            min-height: 100vh;
        }

        .container {
            max-width: 1600px;
            margin: 0 auto;
            padding: 0 2rem;
        }

        /* Header Section */
        .project-header-split {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            margin: 4rem auto 6rem;
            max-width: 1400px;
            gap: 4rem;
            opacity: 0;
            animation: fadeIn 0.8s ease forwards;
            text-align: left;
        }
        
        .header-left {
            flex: 1;
            max-width: 45%;
        }
        
        .header-right {
            flex: 1;
            max-width: 45%;
            padding-top: 1rem;
        }

        .project-title {
            font-family: 'Inter', sans-serif;
            font-size: 3.5rem;
            font-weight: 500;
            margin-bottom: 1.5rem;
            line-height: 1.1;
            text-align: left;
            letter-spacing: -0.02em;
        }

        .project-meta {
            display: flex;
            justify-content: flex-start;
            gap: 1.5rem;
            color: var(--text-light);
            font-size: 0.85rem;
            text-transform: uppercase;
            letter-spacing: 0.1em;
            flex-wrap: wrap;
        }
        
        .meta-item {
            position: relative;
        }
        .meta-item:not(:last-child)::after {
            content: '/';
            position: absolute;
            right: -1.2rem;
            color: #ddd;
        }

        .project-description {
            font-size: 1rem;
            color: #444;
            line-height: 1.8;
            font-weight: 300;
            text-align: left;
            max-width: 100%;
            margin: 0;
        }

        /* Pinterest-Style Masonry Grid */
        .masonry-grid {
            column-count: 3;
            column-gap: 2rem;
            width: 100%;
        }

        .masonry-item {
            break-inside: avoid;
            margin-bottom: 2rem;
            position: relative;
            border-radius: 4px;
            overflow: hidden;
            transition: transform 0.4s ease, box-shadow 0.4s ease;
            opacity: 0;
            animation: fadeIn 0.8s ease forwards;
        }

        .masonry-item:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
        }

        .masonry-item img,
        .masonry-item video {
            width: 100%;
            height: auto;
            display: block;
        }
        
        .item-caption {
            padding: 1rem;
            background: #fff;
            color: #666;
            font-size: 0.85rem;
            text-align: center;
            font-style: italic;
        }

        /* Responsive */
        @media (max-width: 1024px) {
            .masonry-grid { column-count: 2; }
            .project-title { font-size: 3rem; }
        }

        @media (max-width: 768px) {
            .masonry-grid { column-count: 1; }
            .container { padding: 0 1.5rem; }
            .project-title { font-size: 2.5rem; }
            .project-meta { gap: 1rem; font-size: 0.8rem; }
            .meta-item:not(:last-child)::after { display: none; }
        }

        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }
    </style>


    <main>
        <div class="container">
            <!-- Header -->
            <!-- Header -->
            <div class="project-header-split">
                <div class="header-left">
                    <!-- Breadcrumbs -->
                    <div class="project-meta" style="margin-bottom: 1.5rem; opacity: 0.6;">
                        <a href="<?php echo base_url(); ?>" style="color: inherit; text-decoration: none;">HOME</a>
                        <span style="margin: 0 10px;">/</span>
                        <a href="<?php echo base_url('portfolio'); ?>" style="color: inherit; text-decoration: none;">WORK</a>
                        <span style="margin: 0 10px;">/</span>
                        <span style="color: var(--text-main); font-weight: 500;"><?php echo strtoupper($project->title); ?></span>
                    </div>

                    <h1 class="project-title" style="margin-top: 0;"><?php echo $project->title; ?></h1>
                    
                    <?php if (!empty($project->model_name)): ?>
                        <div style="font-size: 1.25rem; color: #666; font-weight: 300; margin-top: -1rem;">
                            <?php echo $project->model_name; ?>
                        </div>
                    <?php endif; ?>
                </div>

                <div class="header-right">
                    <?php if (!empty($project->description)): ?>
                        <div class="project-description" style="font-size: 1.125rem; line-height: 1.8; color: #333;">
                            <?php echo nl2br($project->description); ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Pinterest Grid -->
            <div class="masonry-grid">
                <?php if (!empty($project_media)): ?>
                    <?php foreach ($project_media as $key => $media): ?>
                        <div class="masonry-item" style="animation-delay: <?php echo $key * 0.1; ?>s">
                            <?php if ($media->media_type == 'image'): ?>
                                <img src="<?php echo base_url($media->media_path); ?>" alt="<?php echo htmlspecialchars($project->title); ?>" loading="lazy">
                            <?php else: ?>
                                <video autoplay muted loop playsinline>
                                    <source src="<?php echo base_url($media->media_path); ?>" type="video/mp4">
                                </video>
                            <?php endif; ?>
                            
                            <?php if(!empty($media->caption)): ?>
                                <div class="item-caption"><?php echo $media->caption; ?></div>
                            <?php endif; ?>
                        </div>
                    <?php endforeach; ?>
                <?php else: ?>
                    <!-- Fallback -->
                    <div class="masonry-item">
                        <img src="<?php echo base_url($project->thumbnail_path ?: $project->media_path); ?>" alt="Cover">
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </main>

<?php $this->load->view('templates/footer'); ?>