<div class="row">
    <div class="col-12">
        <h1 class="mb-4">Search Results for "<?php echo htmlspecialchars($search_term); ?>"</h1>
        
        <?php if(empty($projects)): ?>
            <div class="alert alert-info">
                No projects found matching your search criteria.
            </div>
        <?php else: ?>
            <p class="text-muted">Found <?php echo count($projects); ?> project(s)</p>
            
            <div class="row">
                <?php foreach($projects as $project): ?>
                    <div class="col-md-6 col-lg-4">
                        <div class="card project-card">
                            <?php if(!empty($project->image_path)): ?>
                                <img src="<?php echo base_url() . $project->image_path; ?>" class="card-img-top project-image" alt="<?php echo $project->title; ?>">
                            <?php else: ?>
                                <img src="<?php echo base_url(); ?>assets/images/placeholder.jpg" class="card-img-top project-image" alt="No image">
                            <?php endif; ?>
                            <div class="card-body">
                                <h5 class="card-title"><?php echo $project->title; ?></h5>
                                <p class="card-text"><?php echo $project->client; ?> | <?php echo $project->photographer; ?></p>
                                <?php if(!empty($project->description)): ?>
                                    <p class="card-text"><?php echo substr($project->description, 0, 100); ?>...</p>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
        
        <div class="mt-4">
            <a href="<?php echo base_url(); ?>projects" class="btn btn-secondary">Back to All Projects</a>
        </div>
    </div>
</div>