<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>BILI PRODUCTIONS - Fashion & Beauty Production</title>
    <meta name="description" content="Full-service production company specializing in high-end fashion, beauty, and lifestyle content. Expert production services for leading brands.">
    <meta name="author" content="BILI PRODUCTIONS">
    
    <meta property="og:title" content="BILI PRODUCTIONS - Fashion & Beauty Production">
    <meta property="og:description" content="Full-service production company specializing in high-end fashion, beauty, and lifestyle content.">
    <meta property="og:type" content="website">
    
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, sans-serif;
            background: #ffffff;
            color: #1a1a1a;
            line-height: 1.5;
        }

        /* Navigation */
        nav {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            z-index: 1000;
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-bottom: 1px solid #e5e5e5;
        }

        .nav-container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 1.5rem 1.5rem;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .logo {
            font-size: 1.5rem;
            font-weight: 300;
            letter-spacing: 0.1em;
            text-decoration: none;
            color: #1a1a1a;
            transition: opacity 0.3s;
        }

        .logo:hover {
            opacity: 0.7;
        }

        .nav-links {
            display: flex;
            gap: 3rem;
            list-style: none;
        }

        .nav-links a {
            text-decoration: none;
            color: #1a1a1a;
            font-size: 0.875rem;
            letter-spacing: 0.1em;
            font-weight: 300;
            transition: opacity 0.3s;
        }

        .nav-links a:hover {
            opacity: 0.5;
        }

        /* Main Content */
        main {
            padding-top: 6rem;
            padding-bottom: 3rem;
        }

        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 1.5rem;
        }

        /* Grid */
        .grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 1.5rem;
            grid-auto-rows: 300px;
        }

        /* Project Cards */
        .project-card {
            position: relative;
            overflow: hidden;
            background: #f5f5f5;
            cursor: pointer;
        }

        .project-card.medium {
            grid-row: span 2;
        }

        .project-card.large {
            grid-column: span 2;
            grid-row: span 2;
        }

        .project-card img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            transition: transform 0.7s cubic-bezier(0.4, 0, 0.2, 1);
        }

        .project-card:hover img {
            transform: scale(1.05);
        }

        .project-overlay {
            position: absolute;
            inset: 0;
            background: rgba(0, 0, 0, 0.6);
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            opacity: 0;
            transition: opacity 0.3s;
        }

        .project-card:hover .project-overlay {
            opacity: 1;
        }

        .play-icon {
            width: 48px;
            height: 48px;
            margin-bottom: 1rem;
        }

        .project-title {
            color: white;
            font-size: 0.875rem;
            letter-spacing: 0.15em;
            font-weight: 300;
            padding: 0 1rem;
            text-align: center;
        }

        /* Page Sections */
        .page-content {
            display: none;
        }

        .page-content.active {
            display: block;
        }

        .page-title {
            font-size: 2.25rem;
            font-weight: 300;
            letter-spacing: 0.1em;
            margin-bottom: 3rem;
        }

        .about-text {
            max-width: 48rem;
            margin: 0 auto;
        }

        .about-text p {
            margin-bottom: 1.5rem;
            color: rgba(26, 26, 26, 0.8);
            font-weight: 300;
            line-height: 1.75;
        }

        .clients-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 1.5rem;
            max-width: 48rem;
            margin: 0 auto;
        }

        .client-name {
            font-size: 1.25rem;
            font-weight: 300;
            letter-spacing: 0.05em;
            transition: opacity 0.3s;
        }

        .client-name:hover {
            opacity: 0.5;
        }

        /* Responsive */
        @media (max-width: 768px) {
            .nav-links {
                gap: 1.5rem;
            }

            .grid {
                grid-template-columns: 1fr;
            }

            .project-card.large {
                grid-column: span 1;
            }
        }
    </style>
</head>
<body>
    <!-- Navigation -->
    <nav>
        <div class="nav-container">
            <a href="#" class="logo" onclick="showPage('work')">BILI PRODUCTIONS</a>
            <ul class="nav-links">
                <li><a href="#" onclick="showPage('work')">WORK</a></li>
                <li><a href="#" onclick="showPage('about')">ABOUT</a></li>
                <li><a href="#" onclick="showPage('clients')">CLIENTS</a></li>
            </ul>
        </div>
    </nav>

    <!-- Main Content -->
    <main>
        <div class="container">
            <!-- Work Page -->
            <div id="work" class="page-content active">
                <div class="grid">
                    <div class="project-card medium">
                        <img src="https://images.unsplash.com/photo-1515886657613-9f3515b0c78f?w=800&h=1200&fit=crop" alt="LAURA MERCIER | ALEX NATAF">
                        <div class="project-overlay">
                            <p class="project-title">LAURA MERCIER | ALEX NATAF</p>
                        </div>
                    </div>
                    <div class="project-card large">
                        <img src="https://images.unsplash.com/photo-1483985988355-763728e1935b?w=1200&h=800&fit=crop" alt="LAURA MERCIER | MEI TAO">
                        <div class="project-overlay">
                            <svg class="play-icon" fill="white" viewBox="0 0 24 24">
                                <path d="M8 5v14l11-7z"/>
                            </svg>
                            <p class="project-title">LAURA MERCIER | MEI TAO</p>
                        </div>
                    </div>
                    <div class="project-card medium">
                        <img src="https://images.unsplash.com/photo-1469334031218-e382a71b716b?w=800&h=1200&fit=crop" alt="ANN TAYLOR | TOM SCHIRMACHER">
                        <div class="project-overlay">
                            <p class="project-title">ANN TAYLOR | TOM SCHIRMACHER</p>
                        </div>
                    </div>
                    <div class="project-card medium">
                        <img src="https://images.unsplash.com/photo-1490481651871-ab68de25d43d?w=800&h=1200&fit=crop" alt="ANN TAYLOR | ALEX NATAF">
                        <div class="project-overlay">
                            <p class="project-title">ANN TAYLOR | ALEX NATAF</p>
                        </div>
                    </div>
                    <div class="project-card large">
                        <img src="https://images.unsplash.com/photo-1487412720507-e7ab37603c6f?w=1200&h=800&fit=crop" alt="CALVIN KLEIN | CK EVERYONE">
                        <div class="project-overlay">
                            <svg class="play-icon" fill="white" viewBox="0 0 24 24">
                                <path d="M8 5v14l11-7z"/>
                            </svg>
                            <p class="project-title">CALVIN KLEIN | CK EVERYONE</p>
                        </div>
                    </div>
                    <div class="project-card medium">
                        <img src="https://images.unsplash.com/photo-1445205170230-053b83016050?w=800&h=1200&fit=crop" alt="ANN TAYLOR | TOM SCHIRMACHER">
                        <div class="project-overlay">
                            <p class="project-title">ANN TAYLOR | TOM SCHIRMACHER</p>
                        </div>
                    </div>
                    <div class="project-card medium">
                        <img src="https://images.unsplash.com/photo-1515886657613-9f3515b0c78f?w=800&h=1200&fit=crop" alt="ANN TAYLOR SPRING 2025">
                        <div class="project-overlay">
                            <svg class="play-icon" fill="white" viewBox="0 0 24 24">
                                <path d="M8 5v14l11-7z"/>
                            </svg>
                            <p class="project-title">ANN TAYLOR SPRING 2025</p>
                        </div>
                    </div>
                    <div class="project-card medium">
                        <img src="https://images.unsplash.com/photo-1469334031218-e382a71b716b?w=800&h=1200&fit=crop" alt="ANTHROPOLOGIE | EMMA TEMPEST">
                        <div class="project-overlay">
                            <p class="project-title">ANTHROPOLOGIE | EMMA TEMPEST</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- About Page -->
            <div id="about" class="page-content">
                <h1 class="page-title">ABOUT</h1>
                <div class="about-text">
                    <p>
                        BILI PRODUCTIONS is a full-service production company specializing in high-end fashion, 
                        beauty, and lifestyle content. We bring creative visions to life through meticulous 
                        planning and flawless execution.
                    </p>
                    <p>
                        With years of experience working with leading brands and photographers, we handle every 
                        aspect of production—from location scouting and talent booking to on-set coordination 
                        and post-production support.
                    </p>
                    <p>
                        Our commitment to excellence and attention to detail has made us a trusted partner for 
                        brands seeking sophisticated visual storytelling.
                    </p>
                </div>
            </div>

            <!-- Clients Page -->
            <div id="clients" class="page-content">
                <h1 class="page-title">CLIENTS</h1>
                <div class="clients-grid">
                    <div class="client-name">Laura Mercier</div>
                    <div class="client-name">Ann Taylor</div>
                    <div class="client-name">Calvin Klein</div>
                    <div class="client-name">Anthropologie</div>
                    <div class="client-name">J.Crew</div>
                    <div class="client-name">Banana Republic</div>
                    <div class="client-name">Madewell</div>
                    <div class="client-name">Everlane</div>
                </div>
            </div>
        </div>
    </main>

    <script>
        function showPage(pageName) {
            // Hide all pages
            const pages = document.querySelectorAll('.page-content');
            pages.forEach(page => page.classList.remove('active'));
            
            // Show selected page
            document.getElementById(pageName).classList.add('active');
            
            // Prevent default link behavior
            event.preventDefault();
        }
    </script>
</body>
</html>