<div class="row justify-content-center">
    <div class="col-md-8">
        <h1 class="mb-4">Edit Project</h1>
        
        <?php if(isset($error)): ?>
            <div class="alert alert-danger"><?php echo $error; ?></div>
        <?php endif; ?>

        <?php echo form_open_multipart('projects/edit/' . $project->id); ?>
            <div class="mb-3">
                <label for="title" class="form-label">Project Title *</label>
                <input type="text" class="form-control" id="title" name="title" value="<?php echo $project->title; ?>" required>
                <?php echo form_error('title', '<div class="text-danger">', '</div>'); ?>
            </div>

            <div class="mb-3">
                <label for="client" class="form-label">Client *</label>
                <input type="text" class="form-control" id="client" name="client" value="<?php echo $project->client; ?>" required>
                <?php echo form_error('client', '<div class="text-danger">', '</div>'); ?>
            </div>

            <div class="mb-3">
                <label for="photographer" class="form-label">Photographer *</label>
                <input type="text" class="form-control" id="photographer" name="photographer" value="<?php echo $project->photographer; ?>" required>
                <?php echo form_error('photographer', '<div class="text-danger">', '</div>'); ?>
            </div>

            <div class="mb-3">
                <label for="description" class="form-label">Description</label>
                <textarea class="form-control" id="description" name="description" rows="4"><?php echo $project->description; ?></textarea>
            </div>

            <div class="mb-3">
                <label for="image" class="form-label">Project Image</label>
                <input type="file" class="form-control" id="image" name="userfile" accept="image/*">
                <div class="form-text">Leave empty to keep current image. Allowed types: gif, jpg, png, jpeg. Max size: 2MB</div>
                
                <?php if(!empty($project->image_path)): ?>
                    <div class="mt-2">
                        <img src="<?php echo base_url() . $project->image_path; ?>" alt="Current image" class="img-thumbnail" style="max-height: 200px;">
                    </div>
                <?php endif; ?>
            </div>

            <button type="submit" class="btn btn-primary">Update Project</button>
            <a href="<?php echo base_url(); ?>projects/admin" class="btn btn-secondary">Cancel</a>
        <?php echo form_close(); ?>
    </div>
</div>