<div class="row justify-content-center">
    <div class="col-md-8">
        <h1 class="mb-4">Add New Project</h1>
        
        <?php if(isset($error)): ?>
            <div class="alert alert-danger"><?php echo $error; ?></div>
        <?php endif; ?>

        <?php echo form_open_multipart('projects/create'); ?>
            <div class="mb-3">
                <label for="title" class="form-label">Project Title *</label>
                <input type="text" class="form-control" id="title" name="title" required>
                <?php echo form_error('title', '<div class="text-danger">', '</div>'); ?>
            </div>

            <div class="mb-3">
                <label for="client" class="form-label">Client *</label>
                <input type="text" class="form-control" id="client" name="client" required>
                <?php echo form_error('client', '<div class="text-danger">', '</div>'); ?>
            </div>

            <div class="mb-3">
                <label for="photographer" class="form-label">Photographer *</label>
                <input type="text" class="form-control" id="photographer" name="photographer" required>
                <?php echo form_error('photographer', '<div class="text-danger">', '</div>'); ?>
            </div>

            <div class="mb-3">
                <label for="description" class="form-label">Description</label>
                <textarea class="form-control" id="description" name="description" rows="4"></textarea>
            </div>

            <div class="mb-3">
                <label for="image" class="form-label">Project Image *</label>
                <input type="file" class="form-control" id="image" name="userfile" accept="image/*" required>
                <div class="form-text">Allowed types: gif, jpg, png, jpeg. Max size: 2MB</div>
            </div>

            <button type="submit" class="btn btn-primary">Create Project</button>
            <a href="<?php echo base_url(); ?>projects/admin" class="btn btn-secondary">Cancel</a>
        <?php echo form_close(); ?>
    </div>
</div>