<div class="d-flex justify-content-between align-items-center mb-4">
    <h1>Admin Dashboard</h1>
    <a href="<?php echo base_url(); ?>projects/create" class="btn btn-primary">
        <i class="fas fa-plus"></i> Add New Project
    </a>
</div>

<div class="row">
    <?php if(empty($projects)): ?>
        <div class="col-12 text-center">
            <p class="lead">No projects found. <a href="<?php echo base_url(); ?>projects/create">Add your first project</a></p>
        </div>
    <?php else: ?>
        <?php foreach($projects as $project): ?>
            <div class="col-md-6 col-lg-4 position-relative">
                <div class="card project-card">
                    <div class="admin-actions">
                        <a href="<?php echo base_url(); ?>projects/edit/<?php echo $project->id; ?>" class="btn btn-sm btn-warning">
                            <i class="fas fa-edit"></i>
                        </a>
                        <a href="<?php echo base_url(); ?>projects/delete/<?php echo $project->id; ?>" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure you want to delete this project?')">
                            <i class="fas fa-trash"></i>
                        </a>
                    </div>
                    
                    <?php if(!empty($project->image_path)): ?>
                        <img src="<?php echo base_url() . $project->image_path; ?>" class="card-img-top project-image" alt="<?php echo $project->title; ?>">
                    <?php else: ?>
                        <img src="<?php echo base_url(); ?>assets/images/placeholder.jpg" class="card-img-top project-image" alt="No image">
                    <?php endif; ?>
                    
                    <div class="card-body">
                        <h5 class="card-title"><?php echo $project->title; ?></h5>
                        <p class="card-text"><?php echo $project->client; ?> | <?php echo $project->photographer; ?></p>
                        <small class="text-muted">Created: <?php echo date('M j, Y', strtotime($project->created_at)); ?></small>
                    </div>
                </div>
            </div>
        <?php endforeach; ?>
    <?php endif; ?>
</div>