<?php $this->load->view('templates/header'); ?>

<main class="pt-32 pb-24">
  <div class="container">
    <!-- Hero Section -->
    <div class="mb-24" data-reveal>
      <div class="text-left mb-16">
        <span class="tracking-widest uppercase text-muted mb-4 block text-sm">Our Story</span>
        <h1 class="text-5xl md:text-6xl font-light leading-tight">Crafting Visual <br>Excellence Since 2015</h1>
      </div>

      <div class="grid grid-cols-1 md:grid-cols-2 gap-12 items-start">
         <!-- Dynamic Main Image -->
         <div class="aspect-[4/5] bg-secondary overflow-hidden relative w-full h-full min-h-[500px]">
           <?php 
                $img_path = !empty($about->image_path) ? $about->image_path : 'assets/images/placeholder.jpg';
           ?>
           <img src="<?php echo base_url($img_path); ?>?v=<?php echo time(); ?>" alt="<?php echo htmlspecialchars($about->title); ?>" class="w-full h-full object-cover transition-transform duration-700 hover:scale-105 absolute inset-0">
         </div>

        <!-- Content -->
        <div class="text-muted md:text-xl leading-relaxed about-content pt-4">
          <?php 
             $content = !empty($about->content) ? nl2br($about->content) : "Go Productions is a premium film and video production company based in Delhi, India. We specialize in creating compelling visual stories that resonate with audiences and elevate brands to new heights.<br><br>From concept to final cut, we are dedicated to the art of storytelling through a lens of sophistication and style.";
             echo $content;
          ?>
          
        </div>
      </div>
    </div>

    <!-- Stats Section -->
   

    <!-- Image Collage -->
   
    <!-- Approach Section -->
   

  </div> <!-- Close Container Early -->

  <!-- Full Width CTA Section -->
  <div class="w-full py-24 md:py-32 bg-black text-white text-center" style="background-color: #000 !important; color: #fff !important;" data-reveal>
    <div class="container">
      <h2 class="mb-8 text-3xl md:text-5xl font-light">Ready to Start Your Journey?</h2>
      <p class="mb-12 opacity-70 max-w-2xl mx-auto text-lg">
        Let's work together to create something that truly stands out. Our team is ready to bring your vision to life.
      </p>
      <a href="<?php echo base_url('portfolio/contact'); ?>" class="inline-flex items-center gap-2 bg-white text-black px-8 py-4 uppercase tracking-widest text-sm hover:bg-opacity-90 transition-all">
        Inquire Now
        <span style="font-size: 1.2em;">&rarr;</span>
      </a>
    </div>
  </div>
</main>

<?php $this->load->view('templates/footer'); ?>