<?php $this->load->view('templates/header'); ?>

  <!-- Main Content -->
  <main>
    <?php if (isset($canvas_layout) && !empty($canvas_layout)): ?>
      <?php 
        // Determine Height
        if(isset($canvas_height) && !empty($canvas_height)) {
          // Convert raw pixels to VW relative to 1440px
          $container_height_vw = ($canvas_height / 1440) * 100;
        } else {
          // Fallback: Calculate dynamic height based on items
          $max_bottom = 0;
          foreach ($canvas_layout as $item) {
            $bottom = $item['y_pos'] + $item['height']; // Pixels
            if ($bottom > $max_bottom) {
              $max_bottom = $bottom;
            }
          }
          $container_height_vw = ceil(($max_bottom / 1440) * 100);
        }
      ?>
      
      <!-- Full Width Canvas Layout -->
      <style>
        /* Desktop Default (Artistic Canvas) */
        .canvas-container-frontend {
            padding-top: 140px; /* Header Safety Zone */
        }

        /* Mobile Feed Design (Behance Style Stack) */
        @media (max-width: 768px) {
            .canvas-container-frontend {
                height: auto !important;
                display: flex;
                flex-direction: column;
                gap: 2rem; /* Spacing between cards */
                padding-bottom: 4rem;
                padding-left: 1rem;
                padding-right: 1rem;
            }

            .canvas-item-frontend {
                position: relative !important;
                left: auto !important;
                top: auto !important;
                width: 100% !important;
                height: auto !important;
                aspect-ratio: 3/4; /* Portrait Card Ratio */
                margin: 0 !important;
                z-index: 1 !important; /* Reset Z-Index stack */
            }
            
            .media-container {
               border-radius: 0px; /* Clean edges or slight round */
            }

            /* Overlay Gradient for Text Readability */
            .canvas-item-frontend::after {
                content: '';
                position: absolute;
                bottom: 0;
                left: 0;
                width: 100%;
                height: 50%;
                background: linear-gradient(to top, rgba(0,0,0,0.6), transparent);
                pointer-events: none;
                z-index: 2;
            }

            /* Text Overlay Styling */
            .project-label {
                position: absolute !important;
                bottom: 20px !important;
                left: 20px !important;
                text-align: left !important;
                z-index: 3;
                width: auto !important;
            }
            
            .project-label h3 span {
                color: #fff !important; /* Force White Text on Date/Dark BG */
                text-shadow: 0 2px 4px rgba(0,0,0,0.3);
            }
        }
      </style>
      <div class="canvas-container-frontend" style="height: <?php echo $container_height_vw; ?>vw; position: relative; width: 100%; background: white;">
        <?php foreach ($canvas_layout as $item): 
          // Smart Logic: Check if custom thumbnail actually exists
          $media = $item['fallback_media']; // Default to gallery image
          $type = $item['fallback_type'] ?: 'image';

          if (!empty($item['thumbnail_path']) && file_exists(FCPATH . $item['thumbnail_path'])) {
              $media = $item['thumbnail_path'];
              $type = $item['thumbnail_type'];
          }
           
          // Final safety fallback
          if (empty($media) || !file_exists(FCPATH . $media)) {
               $media = 'assets/images/placeholder.jpg';
          }
          
          // Convert Pixels to VW
          $left_vw = ($item['x_pos'] / 1440) * 100;
          $top_vw = ($item['y_pos'] / 1440) * 100;
          $width_vw = ($item['width'] / 1440) * 100;
          $height_vw = ($item['height'] / 1440) * 100;
        ?>
          <div class="canvas-item-frontend" 
               data-reveal
               data-original-top="<?php echo $top_vw; ?>"
               style="
                 position: absolute;
                 left: <?php echo $left_vw; ?>vw;
                 top: <?php echo $top_vw; ?>vw;
                 width: <?php echo $width_vw; ?>vw;
                 height: <?php echo $height_vw; ?>vw;
                 z-index: <?php echo $item['z_index']; ?>;
                 cursor: pointer;
                 /* overflow: hidden; Removed to allow label to be visible */
                 transition: transform 0.5s cubic-bezier(0.77, 0, 0.175, 1);
               " 
               onclick="location.href='<?php echo base_url('portfolio/project/' . $item['project_id']); ?>'">
            
            <!-- Media Container -->
            <div class="media-container" style="width: 100%; height: 100%; overflow: hidden; position: relative;">
              <?php if ($type == 'video'): ?>
                <video autoplay muted loop playsinline preload="metadata" style="width: 100%; height: 100%; object-fit: cover;">
                  <source src="<?php echo base_url($media); ?>?v=<?php echo time(); ?>" type="video/mp4">
                </video>
              <?php else: ?>
                <img src="<?php echo base_url($media); ?>?v=<?php echo time(); ?>" 
                     alt="<?php echo htmlspecialchars($item['title']); ?>" 
                     loading="lazy"
                     decoding="async"
                     style="width: 100%; height: 100%; object-fit: cover;">
              <?php endif; ?>
            </div>

            <!-- Title Below -->
            <div class="project-label" style="
              position: absolute;
              bottom: -30px;
              left: 0;
              text-align: left;
              width: 100%;
              padding-top: 8px;
            ">
              <h3 style="
                font-family: 'Inter', sans-serif;
                font-size: 0.75rem;
                font-weight: 500; /* Increased from 400 */
                letter-spacing: 0.05em;
                text-transform: uppercase;
                color: #666; /* Muted color like screenshot */
                margin: 0;
              ">
                <span style="color: #111; font-weight: 500;"><?php echo $item['title']; ?></span>
                <?php if (!empty($item['model_name'])): ?>
                    <span style="margin: 0 6px; color: #e5e5e5; font-weight: 300;">|</span>
                    <span style="color: #9ca3af; font-weight: 400;"><?php echo $item['model_name']; ?></span>
                <?php endif; ?>
              </h3>
            </div>
          </div>
        <?php endforeach; ?>
      </div>
      
    <?php else: ?>
      <!-- Fallback if no canvas layout -->
      <div class="container" style="padding-top: 120px; min-height: 60vh;">
        <div class="text-center" style="padding: 4rem 0;">
          <h2 style="margin-bottom: 1rem;">No Projects Yet</h2>
          <p style="color: var(--muted);">Projects will appear here once added through the admin panel.</p>
        </div>
      </div>
    <?php endif; ?>
    
    <!-- CTA Section -->
    <section class="py-24 bg-foreground">
      <div class="container">
        <div class="text-center" style="max-width: 1000px; margin: 0 auto;" data-reveal>
          <h2 class="mb-8">Have a project in mind?</h2>
          <p style="font-size: 1.125rem; color: rgba(255, 255, 255, 0.7); margin-bottom: 3rem; max-width: 800px; margin-left: auto; margin-right: auto;">
            Let's collaborate to create something extraordinary. We're always excited to work with brands that share our passion for visual excellence.
          </p>
          <a href="<?php echo base_url('portfolio/contact'); ?>" class="btn btn-primary">
            Get In Touch
            <i data-lucide="arrow-right" style="width: 16px; height: 16px;"></i>
          </a>
        </div>
      </div>
    </section>
  </main>

<?php $this->load->view('templates/footer'); ?>