<?php $this->load->view('templates/header'); ?>

<main class="pt-40 pb-24">
  <div class="container">
    <div class="contact-grid">
      <!-- Contact Info -->
      <div data-reveal>
        <span class="tracking-widest uppercase text-muted mb-4 block">Get In Touch</span>
        <h1 class="mb-8 max-w-lg">Let's Create Something Extraordinary</h1>
        <p class="text-muted mb-12 max-w-md" style="line-height: 1.8;">
          Whether you have a specific project in mind or just want to explore possibilities, we'd love to hear from you.
        </p>
        
        <div class="space-y-8 mb-12">
          <?php if(!empty($contact_settings->email)): ?>
            <div>
              <h4 class="text-sm uppercase tracking-wider mb-2 text-muted">Email</h4>
              <a href="mailto:<?php echo $contact_settings->email; ?>" class="text-xl hover:text-muted-foreground transition-colors">
                <?php echo $contact_settings->email; ?>
              </a>
            </div>
          <?php endif; ?>
          
          <?php if(!empty($contact_settings->phone)): ?>
            <div>
              <h4 class="text-sm uppercase tracking-wider mb-2 text-muted">Phone</h4>
              <a href="tel:<?php echo $contact_settings->phone; ?>" class="text-xl hover:text-muted-foreground transition-colors">
                <?php echo $contact_settings->phone; ?>
              </a>
            </div>
          <?php endif; ?>
          
          <?php if(!empty($contact_settings->address)): ?>
            <div>
              <h4 class="text-sm uppercase tracking-wider mb-2 text-muted">Studio</h4>
              <address class="not-italic text-lg text-muted max-w-xs" style="line-height: 1.6;">
                <?php echo nl2br($contact_settings->address); ?>
              </address>
            </div>
          <?php endif; ?>
        </div>

        <div class="social-links">
           <?php 
              $instagram = !empty($contact_settings->instagram) ? $contact_settings->instagram : "#";
              $linkedin = !empty($contact_settings->linkedin) ? $contact_settings->linkedin : "#";
              $youtube = !empty($contact_settings->youtube) ? $contact_settings->youtube : "#";
           ?>
           <a href="<?php echo $instagram; ?>" target="_blank"><i data-lucide="instagram"></i></a>
           <a href="<?php echo $linkedin; ?>" target="_blank"><i data-lucide="linkedin"></i></a>
           <a href="<?php echo $youtube; ?>" target="_blank"><i data-lucide="youtube"></i></a>
        </div>
      </div>

      <!-- Contact Form -->
      <div class="bg-secondary p-8 md:p-12" data-reveal>
        <form class="contact-form space-y-8" id="contactForm">
           <!-- Form Message -->
           <div id="formMessage" class="mb-6"></div>

          <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
            <div class="form-group">
              <label for="firstName" class="block text-xs uppercase tracking-widest text-muted mb-2">First Name</label>
              <input type="text" id="firstName" name="firstName" required class="w-full bg-transparent border-b border-gray-300 py-3 focus:outline-none focus:border-black transition-colors">
            </div>
            <div class="form-group">
              <label for="lastName" class="block text-xs uppercase tracking-widest text-muted mb-2">Last Name</label>
              <input type="text" id="lastName" name="lastName" required class="w-full bg-transparent border-b border-gray-300 py-3 focus:outline-none focus:border-black transition-colors">
            </div>
          </div>

            <div class="form-group">
              <label for="email" class="block text-xs uppercase tracking-widest text-muted mb-2">Email</label>
              <input type="email" id="email" name="email" required class="w-full bg-transparent border-b border-gray-300 py-3 focus:outline-none focus:border-black transition-colors">
            </div>

            <div class="form-group">
              <label for="phone" class="block text-xs uppercase tracking-widest text-muted mb-2">Phone Number</label>
              <input type="tel" id="phone" name="phone" class="w-full bg-transparent border-b border-gray-300 py-3 focus:outline-none focus:border-black transition-colors">
            </div>
          
           <div class="form-group">
            <label for="subject" class="block text-xs uppercase tracking-widest text-muted mb-2">Subject</label>
             <select id="subject" name="subject" class="w-full bg-transparent border-b border-gray-300 py-3 focus:outline-none focus:border-black transition-colors appearance-none">
                <option value="General Inquiry">General Inquiry</option>
                <option value="Project">Project Proposal</option>
                <option value="Collaboration">Collaboration</option>
             </select>
          </div>

          <div class="form-group">
            <label for="message" class="block text-xs uppercase tracking-widest text-muted mb-2">Message</label>
            <textarea id="message" name="message" rows="1" required class="w-full bg-transparent border-b border-gray-300 py-3 focus:outline-none focus:border-black transition-colors min-h-[100px]"></textarea>
          </div>

          <button type="submit" class="submit-btn w-full btn btn-primary flex justify-center items-center gap-2 py-4 mt-8 bg-black text-white hover:bg-gray-900 transition-colors uppercase tracking-widest text-sm">
            Send Message <span style="font-size: 1.2em;">&rarr;</span>
          </button>
        </form>
      </div>
    </div>
  </div>
    
   <!-- Map Section -->
   <?php if (!empty($contact_settings->google_map_url)): ?>
    <div class="mt-24 w-full h-[500px] contact-map-container">
        <iframe src="<?php echo $contact_settings->google_map_url; ?>" allowfullscreen="" loading="lazy"></iframe>
    </div>
   <?php endif; ?>

</main>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const contactForm = document.getElementById('contactForm');
    if (contactForm) {
        contactForm.addEventListener('submit', function(e) {
            e.preventDefault();
            
            const formData = new FormData(this);
            const submitBtn = this.querySelector('.submit-btn');
            const originalText = submitBtn.innerHTML;
            
            submitBtn.innerHTML = 'Sending...';
            submitBtn.disabled = true;
            
            fetch('<?php echo base_url('portfolio/submit_contact'); ?>', { // Corrected Controller Path
                method: 'POST',
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                const messageDiv = document.getElementById('formMessage');
                if (data.success) {
                    messageDiv.innerHTML = `<div class="p-4 bg-green-100 text-green-800 rounded">${data.message}</div>`;
                    this.reset();
                } else {
                    messageDiv.innerHTML = `<div class="p-4 bg-red-100 text-red-800 rounded">${data.message}</div>`;
                }
            })
            .catch(error => {
                console.error('Error:', error);
                 document.getElementById('formMessage').innerHTML = `<div class="p-4 bg-red-100 text-red-800 rounded">An error occurred. Please try again.</div>`;
            })
            .finally(() => {
                submitBtn.innerHTML = originalText;
                submitBtn.disabled = false;
            });
        });
    }
});
</script>

<?php $this->load->view('templates/footer'); ?>
