<?php $this->load->view('templates/header'); ?>

<main class="pt-40 pb-24">
  <div class="container">
    <!-- Header -->
    <div class="mb-24" data-reveal>
      <h1 class="page-title text-5xl mb-8" style="font-weight: 300; letter-spacing: -0.02em;">Selected Clients</h1>
      <p class="text-muted" style="font-size: 1.125rem; max-width: 600px; line-height: 1.6;">
        We are privileged to work with some of the world's most visionary brands within fashion, beauty, and lifestyle.
      </p>
    </div>

    <!-- Client Grid -->
    <div class="clients-grid mb-32" data-reveal>
      <?php if (isset($clients) && !empty($clients)): ?>
        <?php foreach ($clients as $client): ?>
          <div class="client-card">
            <?php if ($client->logo): ?>
              <img src="<?php echo base_url($client->logo); ?>" 
                   alt="<?php echo htmlspecialchars($client->name); ?>" 
                   loading="lazy">
            <?php else: ?>
              <span class="text-xs uppercase tracking-widest text-muted"><?php echo $client->name; ?></span>
            <?php endif; ?>
          </div>
        <?php endforeach; ?>
      <?php else: ?>
        <p class="text-muted">No clients added yet.</p>
      <?php endif; ?>
    </div>

    <!-- Testimonials (Optional / Static for Design) -->
    

  </div>
</main>

<?php $this->load->view('templates/footer'); ?>