<div class="main-content">
    <div class="page-header">
        <h1>Inquiry Details</h1>
        <div class="header-actions">
            <a href="<?php echo base_url('admin/contact_inquiries'); ?>" class="btn-secondary">Back</a>
            <a href="<?php echo base_url('admin/delete_inquiry/' . $inquiry->id); ?>" class="btn-danger" onclick="return confirm('Delete this inquiry?');">Delete</a>
        </div>
    </div>

    <div class="card">
        <div class="form-group-view">
            <label>Date Received:</label>
            <div class="value"><?php echo date('F j, Y, g:i a', strtotime($inquiry->created_at)); ?></div>
        </div>
        
        <div class="form-group-view">
            <label>Name:</label>
            <div class="value"><?php echo htmlspecialchars($inquiry->name); ?></div>
        </div>
        
        <div class="form-group-view">
            <label>Email:</label>
            <div class="value">
                <a href="mailto:<?php echo htmlspecialchars($inquiry->email); ?>"><?php echo htmlspecialchars($inquiry->email); ?></a>
            </div>
        </div>
        
        <div class="form-group-view">
            <label>Phone:</label>
            <div class="value">
                <?php echo !empty($inquiry->phone) ? htmlspecialchars($inquiry->phone) : '<span class="text-muted">Not provided</span>'; ?>
            </div>
        </div>
        
        <div class="form-group-view">
            <label>Company:</label>
            <div class="value">
                <?php echo !empty($inquiry->company) ? htmlspecialchars($inquiry->company) : '<span class="text-muted">Not provided</span>'; ?>
            </div>
        </div>
        
        <div class="form-group-view">
            <label>Subject:</label>
            <div class="value"><?php echo htmlspecialchars($inquiry->subject); ?></div>
        </div>
        
        <div class="form-group-view full-width">
            <label>Message:</label>
            <div class="value message-box">
                <?php echo nl2br(htmlspecialchars($inquiry->message)); ?>
            </div>
        </div>
    </div>
</div>

<style>
    .page-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 2rem;
    }
    
    .header-actions {
        display: flex;
        gap: 0.75rem;
    }
    
    .btn-secondary {
        display: inline-flex;
        align-items: center;
        padding: 0.6rem 1rem;
        background: #f1f5f9;
        color: #475569;
        text-decoration: none;
        border-radius: 0.5rem;
        font-weight: 600;
        transition: background 0.2s;
        font-size: 0.9rem;
    }
    
    .btn-secondary:hover {
        background: #e2e8f0;
        color: #1e293b;
    }
    
    .btn-danger {
        display: inline-flex;
        align-items: center;
        padding: 0.6rem 1rem;
        background: #fee2e2;
        color: #dc2626;
        text-decoration: none;
        border-radius: 0.5rem;
        font-weight: 600;
        transition: all 0.2s;
        font-size: 0.9rem;
    }
    
    .btn-danger:hover {
        background: #fecaca;
        color: #b91c1c;
    }

    .card {
        background: white;
        border-radius: 0.5rem;
        box-shadow: 0 1px 3px rgba(0,0,0,0.1);
        padding: 2rem;
        display: grid;
        grid-template-columns: repeat(2, 1fr);
        gap: 2rem;
    }
    
    .form-group-view {
        margin-bottom: 0;
    }
    
    .form-group-view label {
        display: block;
        font-weight: 600;
        color: #64748b;
        font-size: 0.875rem;
        text-transform: uppercase;
        letter-spacing: 0.05em;
        margin-bottom: 0.5rem;
    }
    
    .form-group-view .value {
        font-size: 1.125rem;
        color: #1e293b;
    }
    
    .full-width {
        grid-column: 1 / -1;
    }
    
    .message-box {
        background: #f8fafc;
        padding: 1.5rem;
        border-radius: 0.25rem;
        border: 1px solid #e2e8f0;
        line-height: 1.6;
    }
    
    .text-muted {
        color: #94a3b8;
        font-style: italic;
    }
</style>
