<div class="form-manager">
    <div class="manager-header">
        <div class="header-content">
            <h1 class="content-title">Client Details</h1>
            <p class="content-subtitle">View client information and branding assets.</p>
        </div>
        <div class="header-actions">
            <a href="<?php echo base_url('admin/clients/edit/' . $client->id); ?>" class="btn-action btn-primary">
                <i class="fas fa-edit"></i> Edit Client
            </a>
            <a href="<?php echo base_url('admin/clients'); ?>" class="btn-action btn-outline">
                <i class="fas fa-arrow-left"></i> Back to List
            </a>
        </div>
    </div>

    <div class="form-card-container">
        <div class="view-grid">
            <!-- Left Column: Branding -->
            <div class="view-column branding-column">
                <div class="info-card">
                    <div class="card-header">
                        <h3>Branding Asset</h3>
                    </div>
                    <div class="card-body centered">
                        <?php if ($client->logo && file_exists(FCPATH . $client->logo)): ?>
                            <div class="logo-preview-box">
                                <img src="<?php echo base_url($client->logo); ?>" alt="<?php echo htmlspecialchars($client->name); ?>" class="logo-img">
                            </div>
                            <div class="logo-status">
                                <span class="badge badge-success"><i class="fas fa-check"></i> Active Logo</span>
                            </div>
                        <?php else: ?>
                            <div class="logo-preview-box empty">
                                <i class="fas fa-image"></i>
                                <p>No logo uploaded</p>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>

                <div class="info-card mt-4">
                    <div class="card-header">
                        <h3>Quick Stats</h3>
                    </div>
                    <div class="stat-list">
                        <div class="stat-item">
                            <span class="stat-label">Created</span>
                            <span class="stat-value"><?php echo date('M d, Y', strtotime($client->created_at)); ?></span>
                        </div>
                        <div class="stat-item">
                            <span class="stat-label">Last Updated</span>
                            <span class="stat-value">
                                <?php echo isset($client->updated_at) ? date('M d, Y', strtotime($client->updated_at)) : '—'; ?>
                            </span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Right Column: Details -->
            <div class="view-column details-column">
                <div class="info-card">
                    <div class="card-header">
                        <h3>Client Information</h3>
                    </div>
                    <div class="card-body">
                        <div class="details-group">
                            <label>Client Name</label>
                            <div class="value-display text-lg"><?php echo $client->name; ?></div>
                        </div>

                        <div class="details-group">
                            <label>Website URL</label>
                            <div class="value-display">
                                <?php if ($client->website): ?>
                                    <a href="<?php echo $client->website; ?>" target="_blank" class="external-link">
                                        <?php echo $client->website; ?> <i class="fas fa-external-link-alt"></i>
                                    </a>
                                <?php else: ?>
                                    <span class="text-muted">Not provided</span>
                                <?php endif; ?>
                            </div>
                        </div>

                        <div class="details-group">
                            <label>Display Order</label>
                            <div class="value-display">
                                <span class="order-badge">#<?php echo $client->display_order; ?></span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    /* Reuse Form Manager Styles */
    .manager-header {
        display: flex;
        justify-content: space-between;
        align-items: flex-end;
        margin-bottom: 2.5rem;
    }
    .content-title { font-size: 1.75rem; font-weight: 800; color: #000; margin-bottom: 0.25rem; }
    .content-subtitle { color: #6b7280; font-size: 0.95rem; }
    .form-card-container { background: #fff; border-radius: 20px; border: 1px solid #e5e7eb; padding: 2.5rem; }

    /* View Specific Styles */
    .view-grid {
        display: grid;
        grid-template-columns: 300px 1fr;
        gap: 2.5rem;
    }

    .info-card {
        background: #f9fafb;
        border: 1px solid #e5e7eb;
        border-radius: 16px;
        overflow: hidden;
    }
    
    .card-header {
        padding: 1.25rem 1.5rem;
        border-bottom: 1px solid #e5e7eb;
        background: #fff;
    }
    .card-header h3 {
        font-size: 0.95rem;
        font-weight: 700;
        color: #111827;
        text-transform: uppercase;
        letter-spacing: 0.05em;
        margin: 0;
    }

    .card-body { padding: 1.5rem; }
    .card-body.centered { text-align: center; }

    /* Logo Preview */
    .logo-preview-box {
        background: #fff; /* Checkered background for transparency in real app */
        border: 1px solid #e5e7eb;
        border-radius: 12px;
        padding: 2rem;
        margin-bottom: 1rem;
        display: flex;
        align-items: center;
        justify-content: center;
        min-height: 200px;
    }
    .logo-preview-box.empty {
        background: #f3f4f6;
        flex-direction: column;
        color: #9ca3af;
        gap: 0.5rem;
    }
    .logo-preview-box.empty i { font-size: 2.5rem; }
    
    .logo-img {
        max-width: 100%;
        max-height: 150px;
        object-fit: contain;
    }

    .badge {
        display: inline-flex; align-items: center; gap: 0.4rem;
        padding: 0.4rem 0.75rem; border-radius: 99px;
        font-size: 0.75rem; font-weight: 600; text-transform: uppercase;
    }
    .badge-success { background: #dcfce7; color: #166534; }

    /* Details */
    .details-group { margin-bottom: 1.5rem; }
    .details-group:last-child { margin-bottom: 0; }
    
    .details-group label {
        display: block;
        font-size: 0.75rem;
        font-weight: 600;
        color: #6b7280;
        text-transform: uppercase;
        letter-spacing: 0.05em;
        margin-bottom: 0.5rem;
    }
    
    .value-display {
        font-size: 1rem;
        color: #111827;
        font-weight: 500;
    }
    
    .text-lg { font-size: 1.25rem; font-weight: 600; }
    .text-muted { color: #9ca3af; font-style: italic; }

    .external-link {
        color: #2563eb;
        text-decoration: none;
        display: inline-flex;
        align-items: center;
        gap: 0.5rem;
    }
    .external-link:hover { text-decoration: underline; }

    .order-badge {
        background: #000;
        color: #fff;
        padding: 0.25rem 0.75rem;
        border-radius: 6px;
        font-size: 0.85rem;
        font-weight: 600;
    }

    /* Stats */
    .stat-list { display: flex; flex-direction: column; gap: 0.75rem; }
    .stat-item {
        display: flex; justify-content: space-between; align-items: center;
        padding-bottom: 0.75rem; border-bottom: 1px solid #e5e7eb;
    }
    .stat-item:last-child { border-bottom: none; padding-bottom: 0; }
    .stat-label { font-size: 0.85rem; color: #6b7280; }
    .stat-value { font-size: 0.85rem; font-weight: 600; color: #111827; }

    /* Buttons */
    .btn-action {
        padding: 0.75rem 1.5rem; border-radius: 10px; font-weight: 600; font-size: 0.9rem;
        border: 1px solid transparent; text-decoration: none; display: inline-flex; align-items: center; gap: 0.5rem; transition: all 0.2s;
    }
    .btn-primary { background: #000; color: #fff; }
    .btn-primary:hover { background: #222; transform: translateY(-1px); }
    .btn-outline { background: #fff; border-color: #e5e7eb; color: #374151; }
    .btn-outline:hover { border-color: #000; color: #000; }
    .mt-4 { margin-top: 1.5rem; }

    @media (max-width: 900px) {
        .view-grid { grid-template-columns: 1fr; }
        .branding-column { order: -1; }
    }
</style>
