

<div class="projects-manager">
    <div class="manager-header">
        <div class="header-content">
            <h1 class="content-title">Project Manager</h1>
            <p class="content-subtitle">Manage and showcase your best work.</p>
        </div>
        <div class="header-actions">
            <a href="<?php echo base_url('admin/projects/add-wizard'); ?>" class="btn-action btn-primary">
                <i class="fas fa-plus"></i>
                New Project
            </a>
        </div>
    </div>

    <div class="filter-bar">
        <div class="filter-group">
            <button class="filter-btn active">All Work</button>
            <button class="filter-btn">Images</button>
            <button class="filter-btn">Videos</button>
            <button class="filter-btn">Featured</button>
        </div>
        <div class="search-wrapper">
            <i class="fas fa-search"></i>
            <input type="text" placeholder="Search projects...">
        </div>
    </div>

    <div class="projects-grid">
        <?php if ($projects): ?>
            <?php foreach ($projects as $project): ?>
                <div class="project-item-card">
                    <div class="item-media">
                        <?php 
                        // Priority 1: Custom Thumbnail (Explicit File)
                        if (!empty($project->thumbnail_path) && file_exists(FCPATH . $project->thumbnail_path)) {
                            $media_source = $project->thumbnail_path;
                            $media_type = $project->thumbnail_type;
                        } 
                        // Priority 2: Selected Thumbnail (Flagged in Media)
                        elseif (!empty($project->selected_thumb)) {
                             $media_source = $project->selected_thumb;
                             $media_type = $project->selected_thumb_type ?: 'image';
                        }
                        // Priority 3: Raw Project Media (Legacy)
                        elseif (!empty($project->media_path) && file_exists(FCPATH . $project->media_path)) {
                            $media_source = $project->media_path;
                            $media_type = $project->media_type ?: 'image';
                        }
                        // Priority 4: Fallback from Gallery (First Item)
                        elseif (!empty($project->fallback_media)) {
                             $media_source = $project->fallback_media;
                             $media_type = $project->fallback_type ?: 'image';
                        }
                        // Priority 5: Placeholder
                        else {
                            $media_source = 'assets/images/placeholder.jpg';
                            $media_type = 'image';
                        }
                        ?>
                        <?php if ($media_type == 'image'): ?>
                            <img src="<?php echo base_url($media_source); ?>?v=<?php echo time(); ?>" alt="" style="object-fit: cover;" loading="lazy">
                        <?php elseif ($media_type == 'video'): ?>
                            <div class="video-preview" style="background: #000;">
                                <video 
                                    src="<?php echo base_url($media_source); ?>?v=<?php echo time(); ?>" 
                                    muted 
                                    preload="metadata" 
                                    loop 
                                    playsinline
                                    onmouseover="this.play()" 
                                    onmouseout="this.pause();this.currentTime=0;"
                                    style="width: 100%; height: 100%; object-fit: cover;">
                                </video>
                                <i class="fas fa-play-circle" style="pointer-events: none;"></i>
                            </div>
                        <?php endif; ?>
                        
                        <div class="item-badges">
                            <?php if ($project->is_featured): ?>
                                <span class="badge featured">Featured</span>
                            <?php endif; ?>
                            <span class="badge type <?php echo $media_type; ?>"><?php echo ucfirst($media_type); ?></span>
                        </div>
                    </div>
                    
                    <div class="item-details">
                        <div class="item-info">
                            <h3 class="item-title"><?php echo htmlspecialchars($project->title); ?></h3>
                            <p class="item-client"><?php echo htmlspecialchars($project->client_name); ?></p>
                        </div>
                        <div class="item-actions">
                            <a href="<?php echo base_url('admin/projects/edit/' . $project->id); ?>" class="action-btn" title="Edit">
                                <i class="fas fa-pen"></i>
                            </a>
                            <a href="<?php echo base_url('admin/projects/delete/' . $project->id); ?>" class="action-btn delete" title="Delete" onclick="return confirm('Delete this project?')">
                                <i class="fas fa-trash"></i>
                            </a>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        <?php else: ?>
            <div class="empty-state-full">
                <i class="fas fa-photo-video"></i>
                <h3>No projects yet</h3>
                <p>Start by creating your first masterpiece.</p>
                <a href="<?php echo base_url('admin/projects/add-wizard'); ?>" class="btn-action btn-primary">Add Project</a>
            </div>
        <?php endif; ?>
    </div>
</div>

<style>
    .manager-header {
        display: flex;
        justify-content: space-between;
        align-items: flex-end;
        margin-bottom: 2rem;
    }

    .content-title {
        font-size: 1.75rem;
        font-weight: 800;
        color: #000;
        margin-bottom: 0.25rem;
    }

    .content-subtitle {
        color: #6b7280;
        font-size: 0.95rem;
    }

    /* Filter Bar */
    .filter-bar {
        display: flex;
        justify-content: space-between;
        align-items: center;
        background: #fff;
        padding: 0.75rem;
        border-radius: 12px;
        border: 1px solid #e5e7eb;
        margin-bottom: 2rem;
    }

    .filter-group {
        display: flex;
        gap: 0.5rem;
    }

    .filter-btn {
        padding: 0.5rem 1rem;
        border-radius: 8px;
        border: none;
        background: transparent;
        color: #6b7280;
        font-weight: 600;
        font-size: 0.85rem;
        cursor: pointer;
        transition: all 0.2s;
    }

    .filter-btn:hover {
        background: #f3f4f6;
    }

    .filter-btn.active {
        background: #000;
        color: #fff;
    }

    .search-wrapper {
        position: relative;
        width: 300px;
    }

    .search-wrapper i {
        position: absolute;
        left: 1rem;
        top: 50%;
        transform: translateY(-50%);
        color: #9ca3af;
    }

    .search-wrapper input {
        width: 100%;
        padding: 0.6rem 1rem 0.6rem 2.5rem;
        border-radius: 8px;
        border: 1px solid #e5e7eb;
        font-size: 0.875rem;
    }

    /* Projects Grid */
    .projects-grid {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
        gap: 1.5rem;
    }

    .project-item-card {
        background: #fff;
        border-radius: 16px;
        border: 1px solid #e5e7eb;
        overflow: hidden;
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    }

    .project-item-card:hover {
        transform: translateY(-4px);
        box-shadow: 0 12px 24px -10px rgba(0, 0, 0, 0.1);
        border-color: #d1d5db;
    }

    .item-media {
        position: relative;
        aspect-ratio: 4/3;
        background: #f3f4f6;
    }

    .item-media img {
        width: 100%;
        height: 100%;
        object-fit: cover;
    }

    .video-preview {
        position: relative;
        height: 100%;
    }

    .video-preview i {
        position: absolute;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%);
        font-size: 3rem;
        color: #fff;
        z-index: 2;
        text-shadow: 0 4px 10px rgba(0,0,0,0.3);
    }

    .item-badges {
        position: absolute;
        top: 0.75rem;
        left: 0.75rem;
        display: flex;
        flex-direction: column;
        gap: 0.5rem;
    }

    .badge {
        padding: 0.25rem 0.6rem;
        border-radius: 6px;
        font-size: 0.7rem;
        font-weight: 700;
        text-transform: uppercase;
        letter-spacing: 0.025em;
    }

    .badge.featured { background: #000; color: #fff; }
    .badge.type.image { background: rgba(255,255,255,0.9); color: #000; }
    .badge.type.video { background: #ef4444; color: #fff; }

    .item-details {
        padding: 1.25rem;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    .item-title {
        font-size: 0.95rem;
        font-weight: 700;
        color: #111827;
        margin-bottom: 0.2rem;
    }

    .item-client {
        font-size: 0.8rem;
        color: #6b7280;
    }

    .item-actions {
        display: flex;
        gap: 0.5rem;
    }

    .action-btn {
        width: 32px;
        height: 32px;
        border-radius: 8px;
        display: flex;
        align-items: center;
        justify-content: center;
        color: #4b5563;
        text-decoration: none;
        background: #f3f4f6;
        transition: all 0.2s;
    }

    .action-btn:hover {
        background: #000;
        color: #fff;
    }

    .action-btn.delete:hover {
        background: #ef4444;
    }

    .empty-state-full {
        grid-column: 1 / -1;
        text-align: center;
        padding: 6rem 2rem;
        color: #9ca3af;
    }

    .empty-state-full i {
        font-size: 4rem;
        margin-bottom: 1.5rem;
    }

    .empty-state-full h3 {
        color: #111827;
        margin-bottom: 0.5rem;
    }
</style>


