<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>GO PRODUCTIONS - Fashion & Beauty Production</title>
    <meta name="description" content="Full-service production company specializing in high-end fashion, beauty, and lifestyle content. Expert production services for leading brands.">
    <meta name="author" content="GO PRODUCTIONS">
    
    <meta property="og:title" content="GO PRODUCTIONS - Fashion & Beauty Production">
    <meta property="og:description" content="Full-service production company specializing in high-end fashion, beauty, and lifestyle content.">
    <meta property="og:type" content="website">
    
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, sans-serif;
            background: #ffffff;
            color: #1a1a1a;
            line-height: 1.5;
            overflow-x: hidden;
            width: 100%;
        }

        /* Loading Animation */
        .loading-screen {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: #1a1a1a;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            z-index: 9999;
            transition: opacity 0.5s ease, visibility 0.5s ease;
            width: 100%;
        }

        .loading-screen.hidden {
            opacity: 0;
            visibility: hidden;
        }

        .loading-circle {
            width: 150px;
            height: 150px;
            border: 3px solid rgba(255, 255, 255, 0.1);
            border-top: 3px solid #ffffff;
            border-radius: 50%;
            animation: spin 1s linear infinite;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 2rem;
        }

        .loading-text {
            font-size: 2rem;
            font-weight: 300;
            letter-spacing: 0.1em;
            color: #ffffff;
            text-align: center;
        }

        .thunder {
            font-size: 2.5rem;
            animation: thunder 1.5s ease-in-out infinite;
            display: inline-block;
        }

        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }

        @keyframes thunder {
            0%, 100% { 
                opacity: 1;
                text-shadow: 0 0 10px #fff, 0 0 20px #fff, 0 0 30px #ffd700;
            }
            10%, 30%, 50%, 70%, 90% { 
                opacity: 0.3;
                text-shadow: none;
            }
            20%, 40%, 60%, 80% { 
                opacity: 1;
                text-shadow: 0 0 20px #fff, 0 0 40px #fff, 0 0 60px #ffd700, 0 0 80px #ffd700;
            }
        }

        /* Navigation */
        nav {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            z-index: 1000;
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-bottom: 1px solid #e5e5e5;
            width: 100%;
        }

        .nav-container {
            max-width: 100%;
            margin: 0 auto;
            padding: 1.5rem 2rem;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .logo {
            font-size: 1.5rem;
            font-weight: 300;
            letter-spacing: 0.1em;
            text-decoration: none;
            color: #1a1a1a;
            transition: opacity 0.3s;
        }

        .logo:hover {
            opacity: 0.7;
        }

        .nav-links {
            display: flex;
            gap: 3rem;
            list-style: none;
        }

        .nav-links a {
            text-decoration: none;
            color: #1a1a1a;
            font-size: 0.875rem;
            letter-spacing: 0.1em;
            font-weight: 300;
            transition: opacity 0.3s;
        }

        .nav-links a:hover {
            opacity: 0.5;
        }

        /* Main Content */
        main {
            padding-top: 6rem;
            padding-bottom: 3rem;
            min-height: 80vh;
            width: 100%;
        }

        .container {
            width: 100%;
            max-width: none;
            margin: 0;
            padding: 0;
        }

        /* Grid - Full Width */
        .grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 0; /* Remove gaps for full width */
            grid-auto-rows: 300px;
            width: 100%;
        }

        /* Project Cards */
        .project-card {
            position: relative;
            overflow: hidden;
            background: #f5f5f5;
            cursor: pointer;
            border-radius: 0; /* Remove border radius for seamless grid */
            transition: transform 0.3s ease;
        }

        .project-card.medium {
            grid-row: span 2;
        }

        .project-card.large {
            grid-column: span 2;
            grid-row: span 2;
        }

        .project-card.small {
            grid-row: span 1;
        }

        .project-card img,
        .project-card video {
            width: 100%;
            height: 100%;
            object-fit: cover;
            transition: transform 0.7s cubic-bezier(0.4, 0, 0.2, 1);
        }

        .project-card:hover img,
        .project-card:hover video {
            transform: scale(1.05);
        }

        .project-overlay {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0, 0, 0, 0.6);
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            opacity: 0;
            transition: opacity 0.3s ease;
            padding: 1rem;
            text-align: center;
        }

        .project-card:hover .project-overlay {
            opacity: 1;
        }

        .play-icon {
            width: 48px;
            height: 48px;
            margin-bottom: 1rem;
        }

        .project-title {
            color: white;
            font-size: 0.875rem;
            letter-spacing: 0.15em;
            font-weight: 300;
            line-height: 1.4;
        }

        /* Page Content */
        .page-content {
            width: 100%;
        }

        /* Responsive */
        @media (max-width: 768px) {
            .nav-links {
                gap: 1.5rem;
            }

            .grid {
                grid-template-columns: 1fr;
            }

            .project-card.large {
                grid-column: span 1;
            }
            
            .loading-text {
                font-size: 1.5rem;
            }
            
            .loading-circle {
                width: 100px;
                height: 100px;
            }
            
            .nav-container {
                padding: 1rem 1.5rem;
            }
            
            .logo {
                font-size: 1.25rem;
            }
            
            .nav-links a {
                font-size: 0.8rem;
            }
        }

        @media (max-width: 480px) {
            .nav-container {
                padding: 1rem;
            }
            
            .nav-links {
                gap: 1rem;
            }
            
            .logo {
                font-size: 1.1rem;
            }
        }

        /* Large screens - optimize grid for very wide screens */
        @media (min-width: 1920px) {
            .grid {
                grid-template-columns: repeat(auto-fit, minmax(400px, 1fr));
                grid-auto-rows: 400px;
            }
        }

        @media (min-width: 2560px) {
            .grid {
                grid-template-columns: repeat(auto-fit, minmax(500px, 1fr));
                grid-auto-rows: 500px;
            }
        }
    </style>
</head>
<body>
    <!-- Loading Screen -->
    <div class="loading-screen" id="loadingScreen">
        <div class="loading-circle">
            <span class="thunder">⚡</span>
        </div>
        <div class="loading-text">GO PRODUCTIONS</div>
    </div>

    <!-- Navigation -->
    <nav>
        <div class="nav-container">
            <a href="<?php echo base_url(); ?>" class="logo">GO PRODUCTIONS</a>
            <ul class="nav-links">
                <li><a href="<?php echo base_url(); ?>">WORK</a></li>
                <li><a href="<?php echo base_url('about'); ?>">ABOUT</a></li>
                <li><a href="<?php echo base_url('clients'); ?>">CLIENTS</a></li>
                <li><a href="<?php echo base_url('contact'); ?>">CONTACT</a></li>
            </ul>
        </div>
    </nav>

    <!-- Main Content -->
    <main>
        <div class="container">
            <div class="page-content active">
                <div class="grid">
                    <?php 
                    // Define the beautiful grid pattern from your design
                    $pattern = ['medium', 'large', 'medium', 'medium', 'large', 'medium', 'medium', 'medium'];
                    $pattern_index = 0;
                    
                    if (isset($projects) && !empty($projects)): 
                        foreach ($projects as $project): 
                            // Get size from pattern, cycle through if more projects than pattern
                            $size = $pattern[$pattern_index % count($pattern)];
                            $pattern_index++;
                    ?>
                            <div class="project-card <?php echo $size; ?>">
                                <a href="<?php echo base_url('portfolio/project/' . $project->id); ?>">
                                    <?php if ($project->media_type == 'image'): ?>
                                        <img src="<?php echo base_url($project->media_path); ?>" alt="<?php echo htmlspecialchars($project->title); ?>">
                                    <?php else: ?>
                                        <video muted playsinline>
                                            <source src="<?php echo base_url($project->media_path); ?>" type="video/mp4">
                                        </video>
                                    <?php endif; ?>
                                    <div class="project-overlay">
                                        <?php if ($project->media_type == 'video'): ?>
                                            <svg class="play-icon" fill="white" viewBox="0 0 24 24">
                                                <path d="M8 5v14l11-7z"/>
                                            </svg>
                                        <?php endif; ?>
                                        <p class="project-title"><?php echo $project->title; ?></p>
                                        <?php if ($project->client_name): ?>
                                            <p class="project-title" style="font-size: 0.75rem; margin-top: 0.5rem;">
                                                <?php echo $project->client_name; ?>
                                                <?php if ($project->model_name): ?>
                                                     | <?php echo $project->model_name; ?>
                                                <?php endif; ?>
                                            </p>
                                        <?php endif; ?>
                                    </div>
                                </a>
                            </div>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <!-- Show sample projects when no projects in database -->
                        <div class="project-card medium">
                            <img src="https://images.unsplash.com/photo-1515886657613-9f3515b0c78f?w=800&h=1200&fit=crop" alt="LAURA MERCIER | ALEX NATAF">
                            <div class="project-overlay">
                                <p class="project-title">LAURA MERCIER | ALEX NATAF</p>
                            </div>
                        </div>
                        <div class="project-card large">
                            <img src="https://images.unsplash.com/photo-1483985988355-763728e1935b?w=1200&h=800&fit=crop" alt="LAURA MERCIER | MEI TAO">
                            <div class="project-overlay">
                                <svg class="play-icon" fill="white" viewBox="0 0 24 24">
                                    <path d="M8 5v14l11-7z"/>
                                </svg>
                                <p class="project-title">LAURA MERCIER | MEI TAO</p>
                            </div>
                        </div>
                        <div class="project-card medium">
                            <img src="https://images.unsplash.com/photo-1469334031218-e382a71b716b?w=800&h=1200&fit=crop" alt="ANN TAYLOR | TOM SCHIRMACHER">
                            <div class="project-overlay">
                                <p class="project-title">ANN TAYLOR | TOM SCHIRMACHER</p>
                            </div>
                        </div>
                        <div class="project-card medium">
                            <img src="https://images.unsplash.com/photo-1490481651871-ab68de25d43d?w=800&h=1200&fit=crop" alt="ANN TAYLOR | ALEX NATAF">
                            <div class="project-overlay">
                                <p class="project-title">ANN TAYLOR | ALEX NATAF</p>
                            </div>
                        </div>
                        <div class="project-card large">
                            <img src="https://images.unsplash.com/photo-1487412720507-e7ab37603c6f?w=1200&h=800&fit=crop" alt="CALVIN KLEIN | CK EVERYONE">
                            <div class="project-overlay">
                                <svg class="play-icon" fill="white" viewBox="0 0 24 24">
                                    <path d="M8 5v14l11-7z"/>
                                </svg>
                                <p class="project-title">CALVIN KLEIN | CK EVERYONE</p>
                            </div>
                        </div>
                        <div class="project-card medium">
                            <img src="https://images.unsplash.com/photo-1445205170230-053b83016050?w=800&h=1200&fit=crop" alt="ANN TAYLOR | TOM SCHIRMACHER">
                            <div class="project-overlay">
                                <p class="project-title">ANN TAYLOR | TOM SCHIRMACHER</p>
                            </div>
                        </div>
                        <div class="project-card medium">
                            <img src="https://images.unsplash.com/photo-1515886657613-9f3515b0c78f?w=800&h=1200&fit=crop" alt="ANN TAYLOR SPRING 2025">
                            <div class="project-overlay">
                                <svg class="play-icon" fill="white" viewBox="0 0 24 24">
                                    <path d="M8 5v14l11-7z"/>
                                </svg>
                                <p class="project-title">ANN TAYLOR SPRING 2025</p>
                            </div>
                        </div>
                        <div class="project-card medium">
                            <img src="https://images.unsplash.com/photo-1469334031218-e382a71b716b?w=800&h=1200&fit=crop" alt="ANTHROPOLOGIE | EMMA TEMPEST">
                            <div class="project-overlay">
                                <p class="project-title">ANTHROPOLOGIE | EMMA TEMPEST</p>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </main>

    <script>
        // Hide loading screen after page loads
        window.addEventListener('load', function() {
            setTimeout(function() {
                const loadingScreen = document.getElementById('loadingScreen');
                if (loadingScreen) {
                    loadingScreen.classList.add('hidden');
                }
            }, 1500);
        });

        // Optional: Add smooth scroll behavior
        document.addEventListener('DOMContentLoaded', function() {
            // Smooth scrolling for anchor links
            document.querySelectorAll('a[href^="#"]').forEach(anchor => {
                anchor.addEventListener('click', function (e) {
                    e.preventDefault();
                    document.querySelector(this.getAttribute('href')).scrollIntoView({
                        behavior: 'smooth'
                    });
                });
            });
        });
    </script>
</body>
</html>