<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>GO PRODUCTIONS - Admin Login</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --primary: #000000;
            --secondary: #ffffff;
            --bg: #f3f4f6;
            --input-bg: #f9fafb;
            --text-main: #111827;
            --text-muted: #6b7280;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Helvetica, Arial, sans-serif;
        }

        body {
            background-color: var(--secondary);
            height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            overflow: hidden;
        }

        .login-split {
            display: flex;
            width: 100%;
            height: 100%;
        }

        .login-visual {
            flex: 1;
            background: #000;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            color: #fff;
            position: relative;
            overflow: hidden;
        }

        .login-visual::after {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: url('https://media1.calvinklein.com/images/20251028/HP/HP_JK_STL_2b.webp') center/cover no-repeat;
            opacity: 0.3;
            filter: grayscale(100%);
        }

        .visual-content {
            position: relative;
            z-index: 2;
            text-align: center;
        }

        .visual-logo {
            font-size: 3rem;
            font-weight: 900;
            letter-spacing: -2px;
            margin-bottom: 1rem;
        }

        .visual-tagline {
            font-size: 1rem;
            letter-spacing: 4px;
            text-transform: uppercase;
            opacity: 0.7;
        }

        .login-form-side {
            width: 450px;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            padding: 3rem;
            background: #fff;
        }

        .form-container {
            width: 100%;
            max-width: 350px;
            animation: fadeInRight 0.8s cubic-bezier(0.4, 0, 0.2, 1);
        }

        @keyframes fadeInRight {
            from { opacity: 0; transform: translateX(40px); }
            to { opacity: 1; transform: translateX(0); }
        }

        .login-header {
            margin-bottom: 2.5rem;
        }

        .login-header h1 {
            font-size: 1.875rem;
            font-weight: 700;
            color: var(--text-main);
            margin-bottom: 0.5rem;
        }

        .login-header p {
            color: var(--text-muted);
            font-size: 0.95rem;
        }

        .form-group {
            margin-bottom: 1.5rem;
        }

        .form-group label {
            display: block;
            font-size: 0.875rem;
            font-weight: 600;
            color: var(--text-main);
            margin-bottom: 0.5rem;
        }

        .input-wrapper {
            position: relative;
        }

        .form-input {
            width: 100%;
            padding: 0.875rem 1rem;
            background: var(--input-bg);
            border: 1px solid #e5e7eb;
            border-radius: 8px;
            font-size: 1rem;
            transition: all 0.2s;
            color: var(--text-main);
        }

        .form-input:focus {
            outline: none;
            border-color: #000;
            background: #fff;
            box-shadow: 0 0 0 4px rgba(0, 0, 0, 0.05);
        }

        .btn-login {
            width: 100%;
            padding: 1rem;
            background: #000;
            color: #fff;
            border: none;
            border-radius: 8px;
            font-size: 1rem;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.2s;
            margin-top: 1rem;
        }

        .btn-login:hover {
            background: #333;
            transform: translateY(-1px);
        }

        .btn-login:active {
            transform: translateY(0);
        }

        .alert {
            padding: 1rem;
            border-radius: 8px;
            background: #fef2f2;
            color: #991b1b;
            font-size: 0.875rem;
            margin-bottom: 2rem;
            border: 1px solid #fee2e2;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .login-footer {
            margin-top: 3rem;
            text-align: center;
            color: var(--text-muted);
            font-size: 0.8125rem;
        }

        @media (max-width: 900px) {
            .login-visual {
                display: none;
            }
            .login-form-side {
                width: 100%;
            }
        }
    </style>
</head>
<body>
    <div class="login-split">
        <div class="login-visual">
            <div class="visual-content">
                <div class="visual-logo">GO</div>
                <div class="visual-tagline">Productions</div>
            </div>
        </div>
        
        <div class="login-form-side">
            <div class="form-container">
                <div class="login-header">
                    <h1>Welcome back.</h1>
                    <p>Enter your details to access the dashboard.</p>
                </div>

                <?php if (isset($error)): ?>
                    <div class="alert">
                        <i class="fas fa-exclamation-circle"></i>
                        <?php echo $error; ?>
                    </div>
                <?php endif; ?>

                <form method="POST">
                    <div class="form-group">
                        <label for="username">Username</label>
                        <div class="input-wrapper">
                            <input type="text" id="username" name="username" class="form-input" placeholder="e.g. admin" required autofocus>
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="password">Password</label>
                        <div class="input-wrapper">
                            <input type="password" id="password" name="password" class="form-input" placeholder="••••••••" required>
                        </div>
                    </div>

                    <button type="submit" class="btn-login">
                        Sign in
                    </button>
                </form>

                <div class="login-footer">
                    <p>© 2025 GO PRODUCTIONS</p>
                </div>
            </div>
        </div>
    </div>
</body>
</html>