<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard - GO PRODUCTIONS</title>
    
    <!-- Preconnect for Performance -->
    <link rel="preconnect" href="https://cdnjs.cloudflare.com" crossorigin>
    
    <!-- Fonts -->
    <!-- <link rel="stylesheet" href="https://use.typekit.net/xxx.css"> -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" media="print" onload="this.media='all'">
    <noscript><link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css"></noscript>
    
    <style>
        :root {
            --primary: #000000;
            --accent: #3b82f6; /* Subtle accent blue */
            --bg-main: #f8f9fa;
            --sidebar-bg: #ffffff;
            --sidebar-text: #4b5563;
            --sidebar-active: #000000;
            --sidebar-hover: #f3f4f6;
            --card-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.05), 0 2px 4px -1px rgba(0, 0, 0, 0.03);
            --header-height: 70px;
            --sidebar-width: 260px;
            
            /* Status Colors */
            --success: #10b981;
            --error: #ef4444;
            --warning: #f59e0b;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, sans-serif;
        }

        body {
            background: var(--bg-main);
            color: #111827;
            min-height: 100vh;
            display: flex;
        }

        /* Sidebar Styles */
        .admin-sidebar {
            width: var(--sidebar-width);
            background: var(--sidebar-bg);
            border-right: 1px solid #e5e7eb;
            position: fixed;
            height: 100vh;
            z-index: 1000;
            display: flex;
            flex-direction: column;
            transition: width 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            will-change: width, transform;
            transform: translateZ(0); /* Hardware accelerate */
        }

        .sidebar-brand {
            height: var(--header-height);
            display: flex;
            align-items: center;
            padding: 0 1.5rem;
            margin-bottom: 1rem;
        }

        .brand-logo {
            font-size: 1.5rem;
            font-weight: 800;
            letter-spacing: -0.5px;
            color: var(--primary);
            text-decoration: none;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .brand-logo span {
            font-weight: 300;
            font-size: 0.8rem;
            letter-spacing: 2px;
            text-transform: uppercase;
            border-left: 1px solid #e5e7eb;
            padding-left: 0.5rem;
            margin-left: 0.5rem;
        }

        .sidebar-nav {
            flex: 1;
            padding: 0 0.75rem;
            overflow-y: auto;
        }

        .nav-section-title {
            font-size: 0.7rem;
            font-weight: 600;
            color: #9ca3af;
            text-transform: uppercase;
            letter-spacing: 0.05em;
            padding: 1.5rem 1rem 0.5rem;
        }

        .nav-menu {
            list-style: none;
        }

        .nav-item {
            margin-bottom: 2px;
        }

        .nav-link {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            padding: 0.75rem 1rem;
            color: var(--sidebar-text);
            text-decoration: none;
            font-size: 0.925rem;
            font-weight: 500;
            border-radius: 8px;
            transition: all 0.2s;
        }

        .nav-link i {
            width: 20px;
            font-size: 1.1rem;
            opacity: 0.7;
        }

        .nav-link:hover {
            background: var(--sidebar-hover);
            color: var(--primary);
        }

        .nav-link.active {
            background: #000000;
            color: #ffffff;
        }

        .nav-link.active i {
            opacity: 1;
        }

        .sidebar-footer {
            padding: 1rem;
            border-top: 1px solid #e5e7eb;
        }

        .user-profile {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            padding: 0.75rem;
            background: #f9fafb;
            border-radius: 12px;
        }

        .user-avatar {
            width: 36px;
            height: 36px;
            background: #000;
            color: #fff;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 600;
            font-size: 0.9rem;
        }

        .user-meta {
            flex: 1;
            min-width: 0;
        }

        .user-name {
            font-size: 0.875rem;
            font-weight: 600;
            color: #111827;
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
        }

        .logout-link {
            font-size: 0.75rem;
            color: #ef4444;
            text-decoration: none;
            display: block;
            margin-top: 2px;
        }

        /* Main Content wrapper */
        .admin-wrapper {
            flex: 1;
            margin-left: var(--sidebar-width);
            display: flex;
            flex-direction: column;
            min-width: 0;
        }

        /* Top Header */
        .top-header {
            height: var(--header-height);
            background: rgba(255, 255, 255, 0.8);
            backdrop-filter: blur(12px);
            border-bottom: 1px solid #e5e7eb;
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 0 2rem;
            position: sticky;
            top: 0;
            z-index: 900;
        }

        .header-left {
            display: flex;
            align-items: center;
            gap: 1rem;
        }

        .page-indicator {
            font-size: 0.95rem;
            font-weight: 600;
            color: #111827;
        }

        .header-right {
            display: flex;
            align-items: center;
            gap: 1.5rem;
        }

        .view-site-btn {
            padding: 0.5rem 1rem;
            border: 1px solid #e5e7eb;
            border-radius: 8px;
            color: #374151;
            text-decoration: none;
            font-size: 0.875rem;
            font-weight: 500;
            display: flex;
            align-items: center;
            gap: 0.5rem;
            background: #fff;
            transition: all 0.2s;
        }

        .view-site-btn:hover {
            border-color: #000;
            color: #000;
        }

        /* Content Container */
        .main-content {
            padding: 2rem;
            flex: 1;
            max-width: 1400px;
            margin: 0 auto;
            width: 100%;
        }

        /* Alerts */
        .modern-alert {
            padding: 1rem 1.5rem;
            border-radius: 12px;
            margin-bottom: 2rem;
            display: flex;
            align-items: flex-start;
            gap: 1rem;
            font-size: 0.925rem;
            position: relative;
            animation: slideDownFade 0.4s ease-out;
        }

        @keyframes slideDownFade {
            from { opacity: 0; transform: translateY(-10px); }
            to { opacity: 1; transform: translateY(0); }
        }

        .modern-alert-success {
            background: #f0fdf4;
            color: #166534;
            border: 1px solid #bbfcce;
        }

        .modern-alert-error {
            background: #fef2f2;
            color: #991b1b;
            border: 1px solid #fee2e2;
        }

        .alert-icon {
            font-size: 1.25rem;
            margin-top: 1px;
        }

        .alert-close {
            margin-left: auto;
            background: none;
            border: none;
            color: currentColor;
            opacity: 0.5;
            cursor: pointer;
            padding: 2px;
        }

        .alert-close:hover {
            opacity: 1;
        }

        /* Breadcrumbs (Optional but good) */
        .breadcrumbs {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            margin-bottom: 0.5rem;
        }

        .breadcrumb-item {
            font-size: 0.75rem;
            color: #6b7280;
            text-transform: uppercase;
            letter-spacing: 0.05em;
        }

        .breadcrumb-separator {
            font-size: 0.75rem;
            color: #d1d5db;
        }

        /* Responsive Improvements */
        @media (max-width: 1024px) {
            :root {
                --sidebar-width: 80px;
            }
            .sidebar-brand span, .nav-link span, .user-meta, .nav-section-title {
                display: none;
            }
            .nav-link {
                justify-content: center;
                padding: 1rem;
            }
            .brand-logo {
                justify-content: center;
                padding: 0;
            }
        }
    </style>
</head>
<body>
    <!-- Sidebar -->
    <aside class="admin-sidebar">
        <div class="sidebar-brand">
            <a href="<?php echo base_url('admin/dashboard'); ?>" class="brand-logo" style="font-family: 'Playfair Display', serif; font-weight: 700; font-size: 1.2rem; color: #000; text-transform: uppercase; letter-spacing: 1px;">
                GO PRODUCTIONS
            </a>
        </div>
        
        <nav class="sidebar-nav">
            <div class="nav-section-title">Overview</div>
            <ul class="nav-menu">
                <li class="nav-item">
                    <a href="<?php echo base_url('admin/dashboard'); ?>" class="nav-link <?php echo (current_url() == base_url('admin/dashboard')) ? 'active' : ''; ?>">
                        <i class="fas fa-home"></i>
                        <span>Dashboard</span>
                    </a>
                </li>
            </ul>

            <div class="nav-section-title">Content Management</div>
            <ul class="nav-menu">
                <li class="nav-item">
                    <a href="<?php echo base_url('admin/homepage-editor'); ?>" class="nav-link <?php echo (current_url() == base_url('admin/homepage-editor')) ? 'active' : ''; ?>">
                        <i class="fas fa-edit"></i>
                        <span>Home Page Editor</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="<?php echo base_url('admin/projects'); ?>" class="nav-link <?php echo (strpos(current_url(), 'projects') !== false && strpos(current_url(), 'add-wizard') === false) ? 'active' : ''; ?>">
                        <i class="fas fa-images"></i>
                        <span>Project Manager</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="<?php echo base_url('admin/about'); ?>" class="nav-link <?php echo (current_url() == base_url('admin/about')) ? 'active' : ''; ?>">
                        <i class="fas fa-user-friends"></i>
                        <span>About Us</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="<?php echo base_url('admin/clients'); ?>" class="nav-link <?php echo (current_url() == base_url('admin/clients')) ? 'active' : ''; ?>">
                        <i class="fas fa-building"></i>
                        <span>Clients</span>
                    </a>
                </li>
            </ul>

            <div class="nav-section-title">System</div>
            <ul class="nav-menu">
                <li class="nav-item">
                    <a href="<?php echo base_url('admin/contact-inquiries'); ?>" class="nav-link <?php echo (current_url() == base_url('admin/contact-inquiries')) ? 'active' : ''; ?>">
                        <i class="fas fa-envelope"></i>
                        <span>Inquiries</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="<?php echo base_url('admin/contact-settings'); ?>" class="nav-link <?php echo (current_url() == base_url('admin/contact-settings')) ? 'active' : ''; ?>">
                        <i class="fas fa-sliders-h"></i>
                        <span>Settings</span>
                    </a>
                </li>

            </ul>
        </nav>
        
        <div class="sidebar-footer">
            <div class="user-profile">
                <div class="user-avatar">
                    <?php echo strtoupper(substr($this->session->userdata('admin_username'), 0, 1)); ?>
                </div>
                <div class="user-meta">
                    <div class="user-name"><?php echo $this->session->userdata('admin_username'); ?></div>
                    <a href="<?php echo base_url('admin/logout'); ?>" class="logout-link">Logout</a>
                </div>
            </div>
        </div>
    </aside>

    <!-- Main Wrapper -->
    <div class="admin-wrapper">
        <header class="top-header">
            <div class="header-left">
                <div class="page-indicator">
                    <?php 
                        $segment = $this->uri->segment(2);
                        echo strtoupper(str_replace('-', ' ', $segment ?: 'Dashboard'));
                    ?>
                </div>
            </div>
            
            <div class="header-right">
                <a href="<?php echo base_url(); ?>" target="_blank" class="view-site-btn">
                    <i class="fas fa-external-link-alt"></i>
                    View Site
                </a>
            </div>
        </header>

        <main class="main-content">
            <?php if ($this->session->flashdata('success')): ?>
                <div class="modern-alert modern-alert-success">
                    <i class="fas fa-check-circle alert-icon"></i>
                    <div><?php echo $this->session->flashdata('success'); ?></div>
                    <button class="alert-close" onclick="this.parentElement.remove()">&times;</button>
                </div>
            <?php endif; ?>
            
            <?php if ($this->session->flashdata('error')): ?>
                <div class="modern-alert modern-alert-error">
                    <i class="fas fa-exclamation-circle alert-icon"></i>
                    <div><?php echo $this->session->flashdata('error'); ?></div>
                    <button class="alert-close" onclick="this.parentElement.remove()">&times;</button>
                </div>
            <?php endif; ?>