

<div class="form-manager">
    <div class="manager-header">
        <div class="header-content">
            <h1 class="content-title">Edit Project</h1>
            <p class="content-subtitle">Update details for "<?php echo htmlspecialchars($project->title); ?>"</p>
        </div>
        <div class="header-actions">
            <a href="<?php echo base_url('admin/projects'); ?>" class="btn-action btn-outline">
                <i class="fas fa-arrow-left"></i>
                Back to Projects
            </a>
            <a href="<?php echo base_url('project/' . $project->id); ?>" target="_blank" class="btn-action btn-outline">
                <i class="fas fa-external-link-alt"></i>
                View Live
            </a>
        </div>
    </div>

    <div class="form-card-container">
        <form action="<?php echo base_url('admin/projects/edit/' . $project->id); ?>" method="POST" enctype="multipart/form-data" class="modern-form">
            <div class="form-grid-split">
                <!-- Main Info -->
                <div class="form-column">
                    <div class="form-group-modern">
                        <label for="title">Project Title <span class="required-star">*</span></label>
                        <input type="text" id="title" name="title" class="form-control-modern" 
                               value="<?php echo htmlspecialchars($project->title); ?>" required>
                    </div>

                    <div class="form-row-modern">
                        <div class="form-group-modern">
                            <label for="client_name">Client Name <span class="required-star">*</span></label>
                            <input type="text" id="client_name" name="client_name" class="form-control-modern" 
                                   value="<?php echo htmlspecialchars($project->client_name); ?>" required>
                        </div>
                        <div class="form-group-modern">
                            <label for="model_name">Model Name</label>
                            <input type="text" id="model_name" name="model_name" class="form-control-modern" 
                                   value="<?php echo htmlspecialchars($project->model_name); ?>">
                        </div>
                    </div>

                    <div class="form-group-modern">
                        <label for="description">Description</label>
                        <textarea id="description" name="description" class="form-control-modern" rows="6"><?php echo htmlspecialchars($project->description); ?></textarea>
                    </div>

                    <div class="form-row-modern">
                        <div class="form-group-modern">
                            <label for="shoot_date">Shoot Date</label>
                            <input type="date" id="shoot_date" name="shoot_date" class="form-control-modern" 
                                   value="<?php echo $project->shoot_date; ?>">
                        </div>
                        <div class="form-group-modern">
                            <label for="project_size">Grid Size</label>
                            <select id="project_size" name="project_size" class="form-control-modern">
                                <option value="small" <?php echo $project->project_size == 'small' ? 'selected' : ''; ?>>Small</option>
                                <option value="medium" <?php echo $project->project_size == 'medium' ? 'selected' : ''; ?>>Medium</option>
                                <option value="large" <?php echo $project->project_size == 'large' ? 'selected' : ''; ?>>Large</option>
                            </select>
                        </div>
                    </div>

                    <div class="form-row-modern">
                        <div class="form-group-modern">
                            <label for="display_order">Display Order</label>
                            <input type="number" id="display_order" name="display_order" class="form-control-modern" 
                                   value="<?php echo $project->display_order; ?>">
                        </div>
                        <div class="form-group-modern">
                            <label for="aspect_ratio">Aspect Ratio</label>
                            <input type="text" id="aspect_ratio" name="aspect_ratio" class="form-control-modern" 
                                   value="<?php echo isset($project->aspect_ratio) ? $project->aspect_ratio : ''; ?>" placeholder="e.g. 16:9">
                        </div>
                    </div>
                    
                    <div class="form-group-modern">
                         <div class="checkbox-wrapper">
                            <input type="checkbox" id="is_featured" name="is_featured" value="1" <?php echo $project->is_featured ? 'checked' : ''; ?>>
                            <label for="is_featured">Feature this project on the homepage</label>
                        </div>
                    </div>
                </div>

                <!-- Media & Thumbnail -->
                <div class="form-column">
                    <div class="form-group-modern">
                        <label>Thumbnail Media</label>
                        <div class="image-upload-zone" id="thumbnailDropZone">
                            <?php if ($project->thumbnail_path): ?>
                                <div class="current-image-preview">
                                    <?php if ($project->thumbnail_type == 'video'): ?>
                                        <video src="<?php echo base_url($project->thumbnail_path); ?>?v=<?php echo time(); ?>" autoplay muted loop playsinline></video>
                                    <?php else: ?>
                                        <img src="<?php echo base_url($project->thumbnail_path); ?>?v=<?php echo time(); ?>" alt="">
                                    <?php endif; ?>
                                    <div class="image-overlay-info">
                                        <span class="badge"><?php echo ucfirst($project->thumbnail_type); ?></span>
                                    </div>
                                    <div style="position:absolute; bottom:10px; right:10px; background:white; padding:5px 10px; border-radius:8px; box-shadow:0 2px 5px rgba(0,0,0,0.2);">
                                        <input type="checkbox" id="remove_thumb" name="remove_thumbnail" value="1">
                                        <label for="remove_thumb" style="font-size:12px; font-weight:600; color:#ef4444; margin-bottom:0; cursor:pointer;">Remove</label>
                                    </div>
                                </div>
                            <?php else: ?>
                                <div class="upload-placeholder">
                                    <i class="fas fa-image"></i>
                                    <p>Upload Thumbnail</p>
                                    <span>Image or Video</span>
                                </div>
                            <?php endif; ?>
                            <input type="file" id="thumbnail" name="thumbnail" class="file-input-hidden" accept="image/*,video/*">
                        </div>
                        <small class="form-hint">Click to replace. Supports JPG, PNG, MP4, WEBP.</small>
                    </div>

                    <!-- Project Media Summary -->
                    <div class="media-summary-card">
                        <div class="media-header">
                            <h3>Project Gallery</h3>
                            <span class="badge-count"><?php echo count($project_media); ?> items</span>
                        </div>
                        
                        <!-- Inline Upload for New Media -->
                        <div class="gallery-upload-section">
                            <label class="upload-mini-zone" for="galleryMedia" id="galleryZone">
                                <div class="icon-wrap"><i class="fas fa-plus"></i></div>
                                <div class="text-wrap">
                                    <span class="primary-text">Add Media</span>
                                    <span class="secondary-text">Drag & drop or click</span>
                                </div>
                            </label>
                            <input type="file" id="galleryMedia" name="gallery_media[]" multiple accept="image/*,video/*" class="file-input-hidden">
                        </div>
                        <div id="newMediaPreview" class="new-media-grid"></div>

                        <div class="media-grid-preview">
                            <?php foreach (array_slice($project_media, 0, 6) as $media): ?>
                                <div class="media-preview-item">
                                    <a href="<?php echo base_url('admin/delete_media/' . $media->id); ?>" 
                                       onclick="return confirm('Remove this media item?');"
                                       style="position:absolute; top:5px; right:5px; background:red; color:white; border-radius:50%; width:20px; height:20px; text-align:center; line-height:20px; text-decoration:none; font-size:12px; z-index:10;">&times;</a>
                                    
                                    <?php if (strpos($media->media_type, 'video') !== false): ?>
                                        <video src="<?php echo base_url($media->media_path); ?>"></video>
                                        <i class="fas fa-play-circle video-icon"></i>
                                    <?php else: ?>
                                        <img src="<?php echo base_url($media->media_path); ?>" alt="">
                                    <?php endif; ?>
                                </div>
                            <?php endforeach; ?>
                            <?php if (count($project_media) > 6): ?>
                                <div class="media-preview-item more">
                                    <span>+<?php echo count($project_media) - 6; ?></span>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>

            <div class="form-footer-actions">
                <button type="submit" class="btn-action btn-primary">
                    <i class="fas fa-save"></i>
                    Save Changes
                </button>
            </div>
        </form>
    </div>
</div>

<style>
    .manager-header {
        display: flex;
        justify-content: space-between;
        align-items: flex-end;
        margin-bottom: 2.5rem;
    }

    .content-title {
        font-size: 1.75rem;
        font-weight: 800;
        color: #000;
        margin-bottom: 0.25rem;
    }

    .content-subtitle {
        color: #6b7280;
        font-size: 0.95rem;
    }

    .form-card-container {
        background: #fff;
        border-radius: 20px;
        border: 1px solid #e5e7eb;
        padding: 2.5rem;
    }

    .form-grid-split {
        display: grid;
        grid-template-columns: 1.5fr 1fr;
        gap: 3rem;
    }

    .form-group-modern {
        margin-bottom: 1.5rem;
    }

    .form-row-modern {
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 1.5rem;
    }

    .form-group-modern label {
        display: block;
        font-size: 0.9rem;
        font-weight: 600;
        color: #111827;
        margin-bottom: 0.5rem;
    }

    .required-star { color: #ef4444; }

    .form-control-modern {
        width: 100%;
        padding: 0.75rem 1rem;
        background: #f9fafb;
        border: 1px solid #e5e7eb;
        border-radius: 10px;
        font-size: 0.95rem;
        color: #111827;
        transition: all 0.2s;
    }

    .form-control-modern:focus {
        outline: none;
        border-color: #000;
        background: #fff;
        box-shadow: 0 0 0 4px rgba(0,0,0,0.05);
    }
    
    .checkbox-wrapper {
        display: flex;
        align-items: center;
        gap: 0.75rem;
        padding: 1rem;
        background: #f9fafb;
        border-radius: 10px;
        border: 1px solid #e5e7eb;
        cursor: pointer;
    }
    
    .checkbox-wrapper input[type="checkbox"] {
        width: 1.25rem;
        height: 1.25rem;
        border-radius: 4px;
        cursor: pointer;
    }
    
    .checkbox-wrapper label {
        margin-bottom: 0;
        cursor: pointer;
    }

    .form-hint {
        display: block;
        font-size: 0.75rem;
        color: #9ca3af;
        margin-top: 0.4rem;
    }

    /* Image Upload Zone */
    .image-upload-zone {
        border: 2px dashed #e5e7eb;
        border-radius: 16px;
        padding: 1.5rem;
        text-align: center;
        background: #f9fafb;
        cursor: pointer;
        transition: all 0.2s;
        position: relative;
        aspect-ratio: 16/9;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .image-upload-zone:hover {
        border-color: #000;
        background: #f3f4f6;
    }

    .upload-placeholder {
        color: #9ca3af;
    }

    .upload-placeholder i {
        font-size: 2.5rem;
        margin-bottom: 1rem;
        color: #d1d5db;
    }

    .upload-placeholder p {
        font-weight: 600;
        color: #4b5563;
        margin-bottom: 0.25rem;
    }

    .current-image-preview {
        position: relative;
        width: 100%;
        height: 100%;
        border-radius: 12px;
        overflow: hidden;
    }

    .current-image-preview img, .current-image-preview video {
        width: 100%;
        height: 100%;
        object-fit: cover;
    }

    .image-overlay-info {
        position: absolute;
        top: 0.75rem;
        right: 0.75rem;
    }
    
    .badge {
        background: rgba(0,0,0,0.7);
        color: #fff;
        padding: 0.25rem 0.75rem;
        border-radius: 20px;
        font-size: 0.75rem;
        font-weight: 600;
        text-transform: uppercase;
    }

    .file-input-hidden {
        position: absolute;
        top: 0; left: 0; width: 100%; height: 100%;
        opacity: 0;
        cursor: pointer;
    }
    
    /* Media Summary Card */
    .media-summary-card {
        margin-top: 2rem;
        background: #f9fafb;
        border-radius: 16px;
        padding: 1.5rem;
        border: 1px solid #e5e7eb;
    }
    
    .media-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 1rem;
    }
    
    .media-header h3 {
        font-size: 1rem;
        font-weight: 700;
        margin: 0;
    }
    
    .badge-count {
        background: #e5e7eb;
        padding: 0.2rem 0.6rem;
        border-radius: 12px;
        font-size: 0.75rem;
        font-weight: 600;
        color: #4b5563;
    }
    
    .media-grid-preview {
        display: grid;
        grid-template-columns: repeat(3, 1fr);
        gap: 0.5rem;
        margin-bottom: 1rem;
    }
    
    .media-preview-item {
        aspect-ratio: 1;
        border-radius: 8px;
        overflow: hidden;
        position: relative;
        background: #e5e7eb;
    }
    
    .media-preview-item img, .media-preview-item video {
        width: 100%;
        height: 100%;
        object-fit: cover;
    }
    
    .media-preview-item.more {
        background: #d1d5db;
        display: flex;
        align-items: center;
        justify-content: center;
        color: #4b5563;
        font-weight: 700;
    }
    
    .video-icon {
        position: absolute;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%);
        color: #fff;
        font-size: 1.5rem;
        text-shadow: 0 2px 4px rgba(0,0,0,0.3);
    }
    
    .btn-manage-media {
        display: block;
        width: 100%;
        text-align: center;
        padding: 0.75rem;
        background: #fff;
        border: 1px solid #d1d5db;
        border-radius: 8px;
        color: #374151;
        font-weight: 600;
        font-size: 0.9rem;
        text-decoration: none;
        transition: all 0.2s;
    }
    
    .btn-manage-media:hover {
        border-color: #9ca3af;
        background: #f3f4f6;
    }

    .form-footer-actions {
        margin-top: 3rem;
        padding-top: 2rem;
        border-top: 1px solid #f3f4f6;
        display: flex;
        justify-content: flex-end;
    }

    .btn-action {
        padding: 0.875rem 1.75rem;
        border-radius: 12px;
        font-weight: 700;
        font-size: 0.95rem;
        border: 1px solid transparent;
        cursor: pointer;
        display: inline-flex;
        align-items: center;
        gap: 0.75rem;
        transition: all 0.2s;
        text-decoration: none;
    }

    .btn-primary {
        background: #000;
        color: #fff;
    }

    .btn-primary:hover {
        background: #333;
        transform: translateY(-2px);
        box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1);
    }

    .btn-outline {
        background: transparent;
        border-color: #e5e7eb;
        color: #374151;
    }

    .btn-outline:hover {
        border-color: #000;
        color: #000;
        background: #fff;
    }

    @media (max-width: 900px) {
        .form-grid-split {
            grid-template-columns: 1fr;
            gap: 2rem;
        }
        .form-row-modern {
            grid-template-columns: 1fr;
            gap: 1rem;
        }
    }

    /* Gallery Upload Styles */
    .gallery-upload-section { margin-bottom: 1rem; }
    .upload-mini-zone {
        display: flex; align-items: center; gap: 1rem;
        padding: 1rem 1.5rem;
        background: #fff; border: 1px dashed #d1d5db; border-radius: 12px;
        cursor: pointer; transition: all 0.2s;
        position: relative; /* Contain absolute children like file inputs */
    }
    .upload-mini-zone:hover { border-color: #000; background: #fafafa; }
    .icon-wrap {
        width: 32px; height: 32px; background: #000; color: #fff;
        border-radius: 50%; display: flex; align-items: center; justify-content: center; font-size: 0.8rem;
    }
    .text-wrap { display: flex; flex-direction: column; }
    .primary-text { font-weight: 600; font-size: 0.9rem; color: #111827; }
    .secondary-text { font-size: 0.75rem; color: #6b7280; }

    .new-media-grid {
        display: grid; grid-template-columns: repeat(3, 1fr); gap: 0.5rem; margin-bottom: 1rem;
    }
    .new-media-grid:empty { display: none; }
</style>

<script>
    document.getElementById('thumbnailDropZone').addEventListener('click', function() {
        document.getElementById('thumbnail').click();
    });

    document.getElementById('thumbnail').addEventListener('change', function(e) {
        if (this.files && this.files[0]) {
            const reader = new FileReader();
            const file = this.files[0];
            const isVideo = file.type.startsWith('video/');
            
            reader.onload = function(ex) {
                const zone = document.getElementById('thumbnailDropZone');
                let content = '';
                
                if (isVideo) {
                    content = `<video src="${ex.target.result}" autoplay muted loop playsinline></video>`;
                } else {
                    content = `<img src="${ex.target.result}" alt="">`;
                }
                
                zone.innerHTML = `
                    <div class="current-image-preview">
                        ${content}
                        <div class="image-overlay-info">
                            <span class="badge">New ${isVideo ? 'Video' : 'Image'}</span>
                        </div>
                    </div>
                `;
            };
            reader.readAsDataURL(file);
        }
    });

    // Gallery Upload Preview
    document.getElementById('galleryMedia').addEventListener('change', function(e) {
        const grid = document.getElementById('newMediaPreview');
        grid.innerHTML = ''; // Clear previous
        
        Array.from(this.files).forEach(file => {
            const reader = new FileReader();
            const isVideo = file.type.startsWith('video/');
            
            reader.onload = function(ex) {
                const item = document.createElement('div');
                item.className = 'media-preview-item'; // Reuse existing class
                item.style.border = '2px solid #000'; // Highlight new
                
                let content = '';
                if (isVideo) {
                    content = `<video src="${ex.target.result}" muted></video><i class="fas fa-plus video-icon" style="font-size:1rem;"></i>`;
                } else {
                    content = `<img src="${ex.target.result}" alt="">`;
                }
                
                item.innerHTML = content;
                grid.appendChild(item);
            }
            reader.readAsDataURL(file);
        });
    });
</script>


