

<div class="form-manager">
    <div class="manager-header">
        <div class="header-content">
            <h1 class="content-title">Edit About Section</h1>
            <p class="content-subtitle">Refine the details of your studio's story.</p>
        </div>
        <div class="header-actions">
            <a href="<?php echo base_url('admin/about'); ?>" class="btn-action btn-outline">
                <i class="fas fa-arrow-left"></i>
                Back to About
            </a>
        </div>
    </div>

    <div class="form-card-container">
        <form method="post" enctype="multipart/form-data" class="modern-form">
            <div class="form-grid-split">
                <!-- Main Content -->
                <div class="form-column">
                    <div class="form-group-modern">
                        <label for="title">Section Title <span class="required-star">*</span></label>
                        <input type="text" id="title" name="title" class="form-control-modern" 
                               value="<?php echo htmlspecialchars($about->title); ?>" required>
                    </div>

                    <div class="form-group-modern">
                        <label for="content">Section Content <span class="required-star">*</span></label>
                        <textarea id="content" name="content" class="form-control-modern" rows="10" required><?php echo htmlspecialchars($about->content); ?></textarea>
                    </div>

                    <div class="form-group-modern">
                        <label for="quote">Quote (Optional)</label>
                        <textarea id="quote" name="quote" class="form-control-modern" rows="3"><?php echo htmlspecialchars($about->quote); ?></textarea>
                        <small class="form-hint">A highlighted quote that appears within this section.</small>
                    </div>

                    <div class="form-group-modern">
                        <label for="display_order">Display Order</label>
                        <input type="number" id="display_order" name="display_order" class="form-control-modern" 
                               value="<?php echo $about->display_order; ?>" min="0">
                        <small class="form-hint">Determines the sequence of sections on the About page.</small>
                    </div>
                </div>

                <!-- Media -->
                <div class="form-column">
                    <div class="form-group-modern">
                        <label>Section Image</label>
                        <div class="image-upload-zone" id="aboutDropZone">
                            <?php if ($about->image_path): ?>
                                <div class="current-image-preview">
                                    <img src="<?php echo base_url($about->image_path); ?>" alt="" id="previewImg">
                                    <div class="remove-image-overlay">
                                        <input type="checkbox" id="remove_image" name="remove_image" value="1">
                                        <label for="remove_image"><i class="fas fa-trash"></i> Remove Image</label>
                                    </div>
                                </div>
                            <?php else: ?>
                                <div class="upload-placeholder">
                                    <i class="fas fa-cloud-upload-alt"></i>
                                    <p>Click to upload image</p>
                                    <span>JPG, PNG or WEBP</span>
                                </div>
                            <?php endif; ?>
                        </div>
                        <!-- Moved outside to prevent JS from destroying it -->
                        <input type="file" id="image" name="image" class="file-input-hidden" accept="image/*" style="opacity: 0; position: absolute; pointer-events: none;">
                    </div>
                </div>
            </div>

            <div class="form-footer-actions">
                <button type="submit" class="btn-action btn-primary">
                    <i class="fas fa-save"></i>
                    Update Section
                </button>
            </div>
        </form>
    </div>
</div>

<style>
    .manager-header {
        display: flex;
        justify-content: space-between;
        align-items: flex-end;
        margin-bottom: 2.5rem;
    }

    .content-title {
        font-size: 1.75rem;
        font-weight: 800;
        color: #000;
        margin-bottom: 0.25rem;
    }

    .content-subtitle {
        color: #6b7280;
        font-size: 0.95rem;
    }

    .form-card-container {
        background: #fff;
        border-radius: 20px;
        border: 1px solid #e5e7eb;
        padding: 2.5rem;
    }

    .form-grid-split {
        display: grid;
        grid-template-columns: 1.5fr 1fr;
        gap: 3rem;
    }

    .form-group-modern {
        margin-bottom: 1.5rem;
    }

    .form-group-modern label {
        display: block;
        font-size: 0.9rem;
        font-weight: 600;
        color: #111827;
        margin-bottom: 0.5rem;
    }

    .required-star { color: #ef4444; }

    .form-control-modern {
        width: 100%;
        padding: 0.75rem 1rem;
        background: #f9fafb;
        border: 1px solid #e5e7eb;
        border-radius: 10px;
        font-size: 0.95rem;
        color: #111827;
        transition: all 0.2s;
    }

    .form-control-modern:focus {
        outline: none;
        border-color: #000;
        background: #fff;
        box-shadow: 0 0 0 4px rgba(0,0,0,0.05);
    }

    .form-hint {
        display: block;
        font-size: 0.75rem;
        color: #9ca3af;
        margin-top: 0.4rem;
    }

    /* Image Upload Zone */
    .image-upload-zone {
        border: 2px dashed #e5e7eb;
        border-radius: 16px;
        padding: 1.5rem;
        text-align: center;
        background: #f9fafb;
        cursor: pointer;
        transition: all 0.2s;
        position: relative;
        aspect-ratio: 1;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .image-upload-zone:hover {
        border-color: #000;
        background: #f3f4f6;
    }

    .upload-placeholder {
        color: #9ca3af;
    }

    .upload-placeholder i {
        font-size: 3rem;
        margin-bottom: 1rem;
        color: #d1d5db;
    }

    .upload-placeholder p {
        font-weight: 700;
        color: #4b5563;
        margin-bottom: 0.25rem;
    }

    .current-image-preview {
        position: relative;
        width: 100%;
        height: 100%;
        border-radius: 12px;
        overflow: hidden;
    }

    .current-image-preview img {
        width: 100%;
        height: 100%;
        object-fit: cover;
    }

    .remove-image-overlay {
        position: absolute;
        bottom: 0;
        left: 0;
        right: 0;
        background: rgba(239, 68, 68, 0.9);
        color: #fff;
        padding: 0.75rem;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 0.5rem;
        font-size: 0.85rem;
        font-weight: 600;
        transform: translateY(100%);
        transition: transform 0.2s;
    }

    .current-image-preview:hover .remove-image-overlay {
        transform: translateY(0);
    }

    .file-input-hidden {
        position: absolute;
        top: 0; left: 0; width: 100%; height: 100%;
        opacity: 0;
        cursor: pointer;
    }

    .form-footer-actions {
        margin-top: 3rem;
        padding-top: 2rem;
        border-top: 1px solid #f3f4f6;
        display: flex;
        justify-content: flex-end;
    }

    .btn-action {
        padding: 0.875rem 1.75rem;
        border-radius: 12px;
        font-weight: 700;
        font-size: 0.95rem;
        border: 1px solid transparent;
        cursor: pointer;
        display: inline-flex;
        align-items: center;
        gap: 0.75rem;
        transition: all 0.2s;
        text-decoration: none;
    }

    .btn-primary {
        background: #000;
        color: #fff;
    }

    .btn-primary:hover {
        background: #333;
        transform: translateY(-2px);
        box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1);
    }

    .btn-outline {
        background: transparent;
        border-color: #e5e7eb;
        color: #374151;
    }

    .btn-outline:hover {
        border-color: #000;
        color: #000;
    }

    @media (max-width: 900px) {
        .form-grid-split {
            grid-template-columns: 1fr;
            gap: 2rem;
        }
    }
</style>

<script>
    document.getElementById('aboutDropZone').addEventListener('click', function() {
        document.getElementById('image').click();
    });

    document.getElementById('image').addEventListener('change', function(e) {
        if (this.files && this.files[0]) {
            const reader = new FileReader();
            reader.onload = function(ex) {
                const zone = document.getElementById('aboutDropZone');
                zone.innerHTML = `
                    <div class="current-image-preview">
                        <img src="${ex.target.result}" alt="">
                    </div>
                `;
            };
            reader.readAsDataURL(this.files[0]);
        }
    });
</script>

