<?php $this->load->view('admin/header'); ?>

<div class="dashboard-header">
    <div class="header-content">
        <h1 class="content-title">Dashboard Overview</h1>
        <p class="content-subtitle">Welcome back to your studio's management hub.</p>
    </div>
    <div class="header-actions">
        <a href="<?php echo base_url('admin/projects/add-wizard'); ?>" class="btn-action btn-primary">
            <i class="fas fa-plus"></i>
            Create Project
        </a>
    </div>
</div>

<div class="stats-container">
    <div class="modern-stat-card">
        <div class="stat-info">
            <span class="stat-label">Total Projects</span>
            <div class="stat-value"><?php echo $total_projects; ?></div>
        </div>
        <div class="stat-icon-wrapper blue">
            <i class="fas fa-film"></i>
        </div>
    </div>

    <div class="modern-stat-card">
        <div class="stat-info">
            <span class="stat-label">Active Clients</span>
            <div class="stat-value"><?php echo $total_clients; ?></div>
        </div>
        <div class="stat-icon-wrapper purple">
            <i class="fas fa-handshake"></i>
        </div>
    </div>

    <div class="modern-stat-card">
        <div class="stat-info">
            <span class="stat-label">New Inquiries</span>
            <div class="stat-value"><?php echo $total_inquiries; ?></div>
        </div>
        <div class="stat-icon-wrapper orange">
            <i class="fas fa-envelope-open-text"></i>
        </div>
    </div>

    <div class="modern-stat-card">
        <div class="stat-info">
            <span class="stat-label">Portfolio Views</span>
            <div class="stat-value"><?php echo number_format($total_views); ?></div>
        </div>
        <div class="stat-icon-wrapper green">
            <i class="fas fa-eye"></i>
        </div>
    </div>
</div>

<div class="dashboard-grid">
    <!-- Recent Inquiries -->
    <div class="grid-card">
        <div class="card-header">
            <h3 class="card-title">Recent Inquiries</h3>
            <a href="<?php echo base_url('admin/contact-inquiries'); ?>" class="card-action">View All</a>
        </div>
        <div class="card-body">
            <?php if ($recent_inquiries): ?>
                <div class="activity-list">
                    <?php foreach ($recent_inquiries as $inquiry): ?>
                        <div class="activity-item">
                            <div class="activity-avatar">
                                <?php echo strtoupper(substr($inquiry->name, 0, 1)); ?>
                            </div>
                            <div class="activity-content">
                                <div class="activity-title"><?php echo htmlspecialchars($inquiry->name); ?></div>
                                <div class="activity-desc"><?php echo htmlspecialchars($inquiry->email); ?></div>
                            </div>
                            <div class="activity-time">
                                <?php echo date('M j', strtotime($inquiry->created_at)); ?>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php else: ?>
                <div class="empty-state">
                    <i class="fas fa-inbox"></i>
                    <p>No new inquiries</p>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- Quick Links / Shortcuts -->
    <div class="grid-card">
        <div class="card-header">
            <h3 class="card-title">Quick Actions</h3>
        </div>
        <div class="card-body">
            <div class="shortcuts-grid">
                <a href="<?php echo base_url('admin/homepage-editor'); ?>" class="shortcut-item">
                    <div class="shortcut-icon"><i class="fas fa-magic"></i></div>
                    <div class="shortcut-label">Edit Home</div>
                </a>
                <a href="<?php echo base_url('admin/projects/add-wizard'); ?>" class="shortcut-item">
                    <div class="shortcut-icon"><i class="fas fa-upload"></i></div>
                    <div class="shortcut-label">Upload Work</div>
                </a>
                <a href="<?php echo base_url('admin/contact-settings'); ?>" class="shortcut-item">
                    <div class="shortcut-icon"><i class="fas fa-cog"></i></div>
                    <div class="shortcut-label">Settings</div>
                </a>
                <a href="<?php echo base_url('admin/about/add'); ?>" class="shortcut-item">
                    <div class="shortcut-icon"><i class="fas fa-plus-circle"></i></div>
                    <div class="shortcut-label">Add Section</div>
                </a>
            </div>
        </div>
    </div>
</div>

<style>
    /* Dashboard Specific Styles */
    .dashboard-header {
        display: flex;
        justify-content: space-between;
        align-items: flex-end;
        margin-bottom: 2.5rem;
    }

    .content-title {
        font-size: 1.75rem;
        font-weight: 800;
        color: #000;
        margin-bottom: 0.25rem;
    }

    .content-subtitle {
        color: #6b7280;
        font-size: 0.95rem;
    }

    .btn-action {
        padding: 0.75rem 1.25rem;
        border-radius: 10px;
        font-weight: 600;
        font-size: 0.9rem;
        text-decoration: none;
        display: inline-flex;
        align-items: center;
        gap: 0.5rem;
        transition: all 0.2s;
    }

    .btn-primary {
        background: #000;
        color: #fff;
    }

    .btn-primary:hover {
        background: #333;
        transform: translateY(-2px);
    }

    /* Stats container */
    .stats-container {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(240px, 1fr));
        gap: 1.5rem;
        margin-bottom: 2.5rem;
    }

    .modern-stat-card {
        background: #ffffff;
        padding: 1.5rem;
        border-radius: 16px;
        border: 1px solid #e5e7eb;
        display: flex;
        justify-content: space-between;
        align-items: center;
        transition: all 0.3s;
    }

    .modern-stat-card:hover {
        transform: translateY(-4px);
        box-shadow: 0 10px 25px -5px rgba(0, 0, 0, 0.05);
        border-color: #d1d5db;
    }

    .stat-label {
        color: #6b7280;
        font-size: 0.85rem;
        font-weight: 600;
        text-transform: uppercase;
        letter-spacing: 0.025em;
        display: block;
        margin-bottom: 0.5rem;
    }

    .stat-value {
        font-size: 1.75rem;
        font-weight: 800;
        color: #111827;
        line-height: 1;
    }

    .stat-icon-wrapper {
        width: 48px;
        height: 48px;
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 1.25rem;
    }

    .stat-icon-wrapper.blue { background: #eff6ff; color: #3b82f6; }
    .stat-icon-wrapper.purple { background: #faf5ff; color: #a855f7; }
    .stat-icon-wrapper.orange { background: #fffaf0; color: #f97316; }
    .stat-icon-wrapper.green { background: #f0fdf4; color: #22c55e; }

    /* Dashboard Grid */
    .dashboard-grid {
        display: grid;
        grid-template-columns: 2fr 1fr;
        gap: 1.5rem;
    }

    .grid-card {
        background: #fff;
        border-radius: 16px;
        border: 1px solid #e5e7eb;
        overflow: hidden;
    }

    .card-header {
        padding: 1.25rem 1.5rem;
        border-bottom: 1px solid #e5e7eb;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    .card-title {
        font-size: 1rem;
        font-weight: 700;
        color: #111827;
    }

    .card-action {
        font-size: 0.825rem;
        font-weight: 600;
        color: #3b82f6;
        text-decoration: none;
    }

    .card-body {
        padding: 1.5rem;
    }

    /* Activity List */
    .activity-list {
        display: flex;
        flex-direction: column;
        gap: 1.25rem;
    }

    .activity-item {
        display: flex;
        align-items: center;
        gap: 1rem;
    }

    .activity-avatar {
        width: 40px;
        height: 40px;
        background: #f3f4f6;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-weight: 600;
        color: #4b5563;
        flex-shrink: 0;
    }

    .activity-content {
        flex: 1;
        min-width: 0;
    }

    .activity-title {
        font-size: 0.9rem;
        font-weight: 600;
        color: #111827;
        margin-bottom: 0.1rem;
    }

    .activity-desc {
        font-size: 0.825rem;
        color: #6b7280;
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
    }

    .activity-time {
        font-size: 0.75rem;
        color: #9ca3af;
        white-space: nowrap;
    }

    /* Shortcuts Grid */
    .shortcuts-grid {
        display: grid;
        grid-template-columns: repeat(2, 1fr);
        gap: 1rem;
    }

    .shortcut-item {
        padding: 1.25rem 1rem;
        background: #f9fafb;
        border: 1px solid #e5e7eb;
        border-radius: 12px;
        text-align: center;
        text-decoration: none;
        transition: all 0.2s;
    }

    .shortcut-item:hover {
        background: #fff;
        border-color: #000;
        transform: translateY(-2px);
        box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.05);
    }

    .shortcut-icon {
        font-size: 1.25rem;
        color: #000;
        margin-bottom: 0.5rem;
    }

    .shortcut-label {
        font-size: 0.8rem;
        font-weight: 600;
        color: #374151;
    }

    .empty-state {
        text-align: center;
        padding: 2rem;
        color: #9ca3af;
    }

    .empty-state i {
        font-size: 2rem;
        margin-bottom: 0.5rem;
    }

    @media (max-width: 1024px) {
        .dashboard-grid {
            grid-template-columns: 1fr;
        }
    }
</style>

<?php $this->load->view('admin/footer'); ?>