

<div class="settings-manager">
    <div class="manager-header">
        <div class="header-content">
            <h1 class="content-title">Contact Settings</h1>
            <p class="content-subtitle">Update your studio's contact information and map location.</p>
        </div>
    </div>

    <div class="settings-form-container">
        <form method="post" enctype="multipart/form-data" class="modern-form">
            <div class="form-grid">
                <!-- Left Column: Content -->
                <div class="form-column">
                    <div class="form-section-title">Page Hero</div>
                    <div class="form-group-modern">
                        <label for="hero_title">Hero Title</label>
                        <input type="text" id="hero_title" name="hero_title" class="form-control-modern" 
                               value="<?php echo htmlspecialchars($contact_settings->hero_title); ?>" required>
                    </div>

                    <div class="form-group-modern">
                        <label for="hero_description">Hero Description</label>
                        <textarea id="hero_description" name="hero_description" class="form-control-modern" rows="4"><?php echo htmlspecialchars($contact_settings->hero_description); ?></textarea>
                    </div>

                    <div class="form-section-title">Contact Info</div>
                    <div class="form-row-modern">
                        <div class="form-group-modern">
                            <label for="phone">Phone Number</label>
                            <input type="text" id="phone" name="phone" class="form-control-modern" 
                                   value="<?php echo htmlspecialchars($contact_settings->phone); ?>" required>
                        </div>
                        <div class="form-group-modern">
                            <label for="email">Email Address</label>
                            <input type="email" id="email" name="email" class="form-control-modern" 
                                   value="<?php echo htmlspecialchars($contact_settings->email); ?>" required>
                        </div>
                    </div>

                    <div class="form-group-modern">
                        <label for="address">Studio Address</label>
                        <textarea id="address" name="address" class="form-control-modern" rows="3" required><?php echo htmlspecialchars($contact_settings->address); ?></textarea>
                    </div>

                    <div class="form-group-modern">
                        <label for="google_map_url">Google Map Embed URL</label>
                        <input type="url" id="google_map_url" name="google_map_url" class="form-control-modern" 
                               value="<?php echo htmlspecialchars($contact_settings->google_map_url); ?>">
                        <small class="form-hint">Paste the 'src' from the Google Maps iframe embed code.</small>
                    </div>
                </div>

                <!-- Right Column: Media -->
                <div class="form-column">
                    <div class="form-section-title">Visuals</div>
                    <div class="form-group-modern">
                        <label>Contact Image</label>
                        <div class="image-upload-zone" id="dropZone">
                            <?php if ($contact_settings->contact_image): ?>
                                <div class="current-image-preview">
                                    <img src="<?php echo base_url($contact_settings->contact_image); ?>" alt="" id="previewImg">
                                    <div class="remove-image-overlay">
                                        <input type="checkbox" id="remove_image" name="remove_image" value="1">
                                        <label for="remove_image"><i class="fas fa-trash"></i> Remove Image</label>
                                    </div>
                                </div>
                            <?php else: ?>
                                <div class="upload-placeholder">
                                    <i class="fas fa-cloud-upload-alt"></i>
                                    <p>Click or drag to upload</p>
                                    <span>JPG, PNG or WEBP (Max 10MB)</span>
                                </div>
                            <?php endif; ?>
                            <input type="file" id="contact_image" name="contact_image" class="file-input-hidden" accept="image/*">
                        </div>
                    </div>
                </div>
            </div>

            <div class="form-footer-actions">
                <button type="submit" class="btn-action btn-primary">
                    <i class="fas fa-save"></i>
                    Update Settings
                </button>
            </div>
        </form>
    </div>
</div>

<style>
    .manager-header {
        margin-bottom: 2.5rem;
    }

    .content-title {
        font-size: 1.75rem;
        font-weight: 800;
        color: #000;
        margin-bottom: 0.25rem;
    }

    .content-subtitle {
        color: #6b7280;
        font-size: 0.95rem;
    }

    .settings-form-container {
        background: #fff;
        border-radius: 20px;
        border: 1px solid #e5e7eb;
        padding: 2.5rem;
    }

    .form-grid {
        display: grid;
        grid-template-columns: 1.5fr 1fr;
        gap: 3rem;
    }

    .form-section-title {
        font-size: 0.8rem;
        font-weight: 700;
        text-transform: uppercase;
        letter-spacing: 0.1em;
        color: #9ca3af;
        margin-bottom: 1.5rem;
        display: flex;
        align-items: center;
        gap: 1rem;
    }

    .form-section-title::after {
        content: '';
        height: 1px;
        background: #f3f4f6;
        flex: 1;
    }

    .form-group-modern {
        margin-bottom: 1.5rem;
    }

    .form-group-modern label {
        display: block;
        font-size: 0.9rem;
        font-weight: 600;
        color: #111827;
        margin-bottom: 0.5rem;
    }

    .form-control-modern {
        width: 100%;
        padding: 0.75rem 1rem;
        background: #f9fafb;
        border: 1px solid #e5e7eb;
        border-radius: 10px;
        font-size: 0.95rem;
        color: #111827;
        transition: all 0.2s;
    }

    .form-control-modern:focus {
        outline: none;
        border-color: #000;
        background: #fff;
        box-shadow: 0 0 0 4px rgba(0,0,0,0.05);
    }

    .form-row-modern {
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 1rem;
    }

    .form-hint {
        display: block;
        font-size: 0.75rem;
        color: #9ca3af;
        margin-top: 0.4rem;
    }

    /* Image Upload Zone */
    .image-upload-zone {
        border: 2px dashed #e5e7eb;
        border-radius: 16px;
        padding: 1.5rem;
        text-align: center;
        background: #f9fafb;
        cursor: pointer;
        transition: all 0.2s;
        position: relative;
    }

    .image-upload-zone:hover {
        border-color: #000;
        background: #f3f4f6;
    }

    .upload-placeholder {
        color: #9ca3af;
        padding: 2rem 0;
    }

    .upload-placeholder i {
        font-size: 2.5rem;
        margin-bottom: 1rem;
        color: #d1d5db;
    }

    .upload-placeholder p {
        font-weight: 600;
        color: #4b5563;
        margin-bottom: 0.25rem;
    }

    .upload-placeholder span {
        font-size: 0.75rem;
    }

    .current-image-preview {
        position: relative;
        border-radius: 12px;
        overflow: hidden;
        aspect-ratio: 4/5;
    }

    .current-image-preview img {
        width: 100%;
        height: 100%;
        object-fit: cover;
    }

    .remove-image-overlay {
        position: absolute;
        bottom: 0;
        left: 0;
        right: 0;
        background: rgba(239, 68, 68, 0.9);
        color: #fff;
        padding: 0.75rem;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 0.5rem;
        font-size: 0.85rem;
        font-weight: 600;
        transform: translateY(100%);
        transition: transform 0.2s;
    }

    .current-image-preview:hover .remove-image-overlay {
        transform: translateY(0);
    }

    .file-input-hidden {
        position: absolute;
        top: 0; left: 0; width: 100%; height: 100%;
        opacity: 0;
        cursor: pointer;
    }

    .form-footer-actions {
        margin-top: 3rem;
        padding-top: 2rem;
        border-top: 1px solid #f3f4f6;
        display: flex;
        justify-content: flex-end;
    }

    .btn-action {
        padding: 0.875rem 1.75rem;
        border-radius: 12px;
        font-weight: 700;
        font-size: 0.95rem;
        border: none;
        cursor: pointer;
        display: inline-flex;
        align-items: center;
        gap: 0.75rem;
        transition: all 0.2s;
    }

    .btn-primary {
        background: #000;
        color: #fff;
    }

    .btn-primary:hover {
        background: #333;
        transform: translateY(-2px);
        box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1);
    }

    @media (max-width: 1024px) {
        .form-grid {
            grid-template-columns: 1fr;
            gap: 2rem;
        }
    }
</style>

<script>
    document.getElementById('dropZone').addEventListener('click', function() {
        document.getElementById('contact_image').click();
    });

    document.getElementById('contact_image').addEventListener('change', function(e) {
        if (this.files && this.files[0]) {
            const reader = new FileReader();
            reader.onload = function(ex) {
                const zone = document.getElementById('dropZone');
                zone.innerHTML = `
                    <div class="current-image-preview">
                        <img src="${ex.target.result}" alt="">
                        <div class="remove-image-overlay" style="transform:translateY(0)">
                            <span>New Image Selected</span>
                        </div>
                    </div>
                `;
            };
            reader.readAsDataURL(this.files[0]);
        }
    });
</script>

