

<div class="inquiries-manager">
    <div class="manager-header">
        <div class="header-content">
            <h1 class="content-title">Contact Inquiries</h1>
            <p class="content-subtitle">Review messages from prospective clients and partners.</p>
        </div>
    </div>

    <div class="inquiries-list-card">
        <?php if ($inquiries): ?>
            <div class="table-responsive">
                <table class="modern-table">
                    <thead>
                        <tr>
                            <th>Contact</th>
                            <th>Company</th>
                            <th style="width: 40%;">Message</th>
                            <th>Date</th>
                            <th class="text-right">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($inquiries as $inquiry): ?>
                        <tr>
                            <td>
                                <div class="sender-info">
                                    <div class="sender-name"><?php echo htmlspecialchars($inquiry->name); ?></div>
                                    <div class="sender-email"><?php echo htmlspecialchars($inquiry->email); ?></div>
                                    <?php if ($inquiry->phone): ?>
                                        <div class="sender-phone"><i class="fas fa-phone-alt"></i> <?php echo htmlspecialchars($inquiry->phone); ?></div>
                                    <?php endif; ?>
                                </div>
                            </td>
                            <td>
                                <div class="company-name"><?php echo $inquiry->company ?: '<span class="text-muted">N/A</span>'; ?></div>
                            </td>
                            <td>
                                <div class="message-preview">
                                    <?php echo nl2br(htmlspecialchars($inquiry->message)); ?>
                                </div>
                            </td>
                            <td>
                                <div class="date-info">
                                    <div class="date-day"><?php echo date('M j, Y', strtotime($inquiry->created_at)); ?></div>
                                    <div class="date-time"><?php echo date('g:i A', strtotime($inquiry->created_at)); ?></div>
                                </div>
                            </td>
                            <td class="text-right">
                                <div class="table-actions">
                                    <a href="<?php echo base_url('admin/view_inquiry/' . $inquiry->id); ?>" class="table-btn" title="View Details">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                    <button class="table-btn" title="Mark as Read">
                                        <i class="fas fa-check"></i>
                                    </button>
                                    <a href="<?php echo base_url('admin/delete_inquiry/' . $inquiry->id); ?>" 
                                       class="table-btn delete" 
                                       title="Delete" 
                                       onclick="return confirm('Delete this inquiry?');">
                                        <i class="fas fa-trash"></i>
                                    </a>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <div class="empty-state-section">
                <i class="fas fa-envelope-open"></i>
                <h3>No inquiries yet</h3>
                <p>New messages from your contact form will appear here.</p>
            </div>
        <?php endif; ?>
    </div>
</div>

<style>
    .manager-header {
        display: flex;
        justify-content: space-between;
        align-items: flex-end;
        margin-bottom: 2.5rem;
    }

    .content-title {
        font-size: 1.75rem;
        font-weight: 800;
        color: #000;
        margin-bottom: 0.25rem;
    }

    .content-subtitle {
        color: #6b7280;
        font-size: 0.95rem;
    }

    .inquiries-list-card {
        background: #fff;
        border-radius: 16px;
        border: 1px solid #e5e7eb;
        overflow: hidden;
    }

    .modern-table {
        width: 100%;
        border-collapse: collapse;
    }

    .modern-table th {
        text-align: left;
        padding: 1.25rem 1.5rem;
        font-size: 0.75rem;
        font-weight: 700;
        text-transform: uppercase;
        letter-spacing: 0.05em;
        color: #6b7280;
        border-bottom: 1px solid #e5e7eb;
        background: #f9fafb;
    }

    .modern-table td {
        padding: 1.25rem 1.5rem;
        border-bottom: 1px solid #f3f4f6;
        vertical-align: top;
    }

    .sender-name {
        font-weight: 700;
        color: #111827;
        font-size: 0.95rem;
        margin-bottom: 0.1rem;
    }

    .sender-email {
        font-size: 0.825rem;
        color: #3b82f6;
    }

    .sender-phone {
        font-size: 0.75rem;
        color: #6b7280;
        margin-top: 0.25rem;
    }

    .company-name {
        font-weight: 600;
        color: #374151;
        font-size: 0.875rem;
    }

    .message-preview {
        font-size: 0.875rem;
        color: #4b5563;
        line-height: 1.5;
        max-height: 100px;
        overflow-y: auto;
    }

    .date-day {
        font-weight: 600;
        color: #111827;
        font-size: 0.85rem;
    }

    .date-time {
        font-size: 0.75rem;
        color: #9ca3af;
    }

    .table-actions {
        display: flex;
        gap: 0.5rem;
        justify-content: flex-end;
    }

    .table-btn {
        width: 36px;
        height: 36px;
        border-radius: 10px;
        display: flex;
        align-items: center;
        justify-content: center;
        color: #4b5563;
        background: #f9fafb;
        border: 1px solid #e5e7eb;
        cursor: pointer;
        transition: all 0.2s;
    }

    .table-btn:hover {
        background: #000;
        color: #fff;
    }

    .table-btn.delete:hover {
        background: #ef4444;
        border-color: #ef4444;
    }

    .empty-state-section {
        text-align: center;
        padding: 5rem 2rem;
        color: #9ca3af;
    }

    .empty-state-section i {
        font-size: 3.5rem;
        margin-bottom: 1.5rem;
    }

    .text-right { text-align: right !important; }
    .text-muted { color: #d1d5db; }
</style>

