

<div class="clients-manager">
    <div class="manager-header">
        <div class="header-content">
            <h1 class="content-title">Client Management</h1>
            <p class="content-subtitle">Showcase the prestigious brands you work with.</p>
        </div>
        <div class="header-actions">
            <a href="<?php echo base_url('admin/clients/add'); ?>" class="btn-action btn-primary">
                <i class="fas fa-plus"></i>
                Add Client
            </a>
        </div>
    </div>

    <div class="clients-list-card">
        <?php if ($clients): ?>
            <div class="table-responsive">
                <table class="modern-table">
                    <thead>
                        <tr>
                            <th>Logo</th>
                            <th>Brand Name</th>
                            <th>Website</th>
                            <th class="text-center">Order</th>
                            <th class="text-right">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($clients as $client): ?>
                        <tr>
                            <td>
                                <div class="client-logo-preview">
                                    <?php if ($client->logo && file_exists(FCPATH . $client->logo)): ?>
                                        <img src="<?php echo base_url($client->logo); ?>" alt="">
                                    <?php else: ?>
                                        <div class="logo-placeholder">
                                            <i class="fas fa-building"></i>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </td>
                            <td>
                                <div class="client-name"><?php echo htmlspecialchars($client->name); ?></div>
                            </td>
                            <td>
                                <?php if ($client->website): ?>
                                    <a href="<?php echo $client->website; ?>" target="_blank" class="client-link">
                                        <i class="fas fa-external-link-alt"></i>
                                        <?php echo parse_url($client->website, PHP_URL_HOST); ?>
                                    </a>
                                <?php else: ?>
                                    <span class="text-muted">No website</span>
                                <?php endif; ?>
                            </td>
                            <td class="text-center">
                                <span class="order-badge"><?php echo $client->display_order; ?></span>
                            </td>
                            <td class="text-right">
                                <div class="table-actions">
                                    <a href="<?php echo base_url('admin/clients/edit/' . $client->id); ?>" class="table-btn" title="Edit">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <a href="<?php echo base_url('admin/clients/delete/' . $client->id); ?>" class="table-btn delete" title="Delete" onclick="return confirm('Delete this client?')">
                                        <i class="fas fa-trash"></i>
                                    </a>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <div class="empty-state-section">
                <i class="fas fa-handshake"></i>
                <h3>No clients found</h3>
                <p>Add your first client to display them on your website.</p>
                <a href="<?php echo base_url('admin/clients/add'); ?>" class="btn-action btn-primary">Add Client</a>
            </div>
        <?php endif; ?>
    </div>
</div>

<style>
    .manager-header {
        display: flex;
        justify-content: space-between;
        align-items: flex-end;
        margin-bottom: 2.5rem;
    }

    .content-title {
        font-size: 1.75rem;
        font-weight: 800;
        color: #000;
        margin-bottom: 0.25rem;
    }

    .content-subtitle {
        color: #6b7280;
        font-size: 0.95rem;
    }

    .clients-list-card {
        background: #fff;
        border-radius: 16px;
        border: 1px solid #e5e7eb;
        overflow: hidden;
    }

    .modern-table {
        width: 100%;
        border-collapse: collapse;
    }

    .modern-table th {
        text-align: left;
        padding: 1.25rem 1.5rem;
        font-size: 0.75rem;
        font-weight: 700;
        text-transform: uppercase;
        letter-spacing: 0.05em;
        color: #6b7280;
        border-bottom: 1px solid #e5e7eb;
        background: #f9fafb;
    }

    .modern-table td {
        padding: 1.25rem 1.5rem;
        border-bottom: 1px solid #f3f4f6;
        vertical-align: middle;
    }

    .client-logo-preview {
        width: 100px;
        height: 50px;
        background: #fdfdfd;
        border: 1px solid #f3f4f6;
        border-radius: 8px;
        display: flex;
        align-items: center;
        justify-content: center;
        overflow: hidden;
        padding: 5px;
    }

    .client-logo-preview img {
        max-width: 100%;
        max-height: 100%;
        object-fit: contain;
    }

    .logo-placeholder {
        color: #d1d5db;
        font-size: 1.25rem;
    }

    .client-name {
        font-weight: 600;
        color: #111827;
        font-size: 0.95rem;
    }

    .client-link {
        color: #3b82f6;
        text-decoration: none;
        font-size: 0.875rem;
        display: inline-flex;
        align-items: center;
        gap: 0.4rem;
    }

    .client-link:hover {
        text-decoration: underline;
    }

    .order-badge {
        display: inline-block;
        padding: 0.25rem 0.75rem;
        background: #f3f4f6;
        border-radius: 20px;
        font-size: 0.85rem;
        font-weight: 600;
        color: #4b5563;
    }

    .table-actions {
        display: flex;
        gap: 0.5rem;
        justify-content: flex-end;
    }

    .table-btn {
        width: 36px;
        height: 36px;
        border-radius: 10px;
        display: flex;
        align-items: center;
        justify-content: center;
        color: #4b5563;
        background: #f9fafb;
        border: 1px solid #e5e7eb;
        text-decoration: none;
        transition: all 0.2s;
    }

    .table-btn:hover {
        background: #000;
        color: #fff;
        border-color: #000;
    }

    .table-btn.delete:hover {
        background: #ef4444;
        border-color: #ef4444;
    }

    .empty-state-section {
        text-align: center;
        padding: 5rem 2rem;
        color: #9ca3af;
    }

    .empty-state-section i {
        font-size: 3.5rem;
        margin-bottom: 1.5rem;
    }

    .text-center { text-align: center !important; }
    .text-right { text-align: right !important; }
    .text-muted { color: #9ca3af; font-size: 0.875rem; }
</style>

<?php $this->load->view('admin/header'); ?>
