

<div class="admin-container">
    <div class="page-header">
        <h1 class="page-title">Create New Project</h1>
        <div class="header-actions">
            <a href="<?php echo base_url('admin/projects'); ?>" class="btn btn-outline">
                <i class="fas fa-arrow-left"></i> Back to Projects
            </a>
        </div>
    </div>

    <div class="project-creation-wizard">
        <!-- Step 1: Basic Information -->
        <div class="wizard-step active" id="step1">
            <div class="form-container">
                <h3><i class="fas fa-info-circle"></i> Project Basic Information</h3>
                <form id="basicInfoForm">
                    <div class="form-grid">
                        <div class="form-group">
                            <label for="title">Project Title *</label>
                            <input type="text" id="title" name="title" required placeholder="Enter project title">
                        </div>
                        
                        <div class="form-group">
                            <label for="client_name">Client Name *</label>
                            <input type="text" id="client_name" name="client_name" required placeholder="Enter client name">
                        </div>
                        
                        <div class="form-group">
                            <label for="model_name">Model Name</label>
                            <input type="text" id="model_name" name="model_name" placeholder="Enter model name (optional)">
                        </div>
                        
                        <div class="form-group">
                            <label for="shoot_date">Shoot Date</label>
                            <input type="date" id="shoot_date" name="shoot_date">
                        </div>
                        
                        <div class="form-group">
                            <label for="project_size">Project Size *</label>
                            <select id="project_size" name="project_size" required>
                                <option value="small">Small</option>
                                <option value="medium" selected>Medium</option>
                                <option value="large">Large</option>
                            </select>
                        </div>
                        
                        <div class="form-group">
                            <label for="display_order">Display Order</label>
                            <input type="number" id="display_order" name="display_order" value="0" min="0">
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label for="description">Description</label>
                        <textarea id="description" name="description" rows="4" placeholder="Describe your project..."></textarea>
                    </div>
                    
                    <div class="form-group">
                        <label class="checkbox-group">
                            <input type="checkbox" name="is_featured" value="1">
                            <span>Feature this project on homepage</span>
                        </label>
                    </div>
                    
                    <div class="form-actions">
                        <button type="button" class="btn btn-primary" onclick="nextStep(2)">
                            Next: Upload Media <i class="fas fa-arrow-right"></i>
                        </button>
                    </div>
                </form>
            </div>
        </div>

        <!-- Step 2: Media Upload -->
        <div class="wizard-step" id="step2">
            <div class="form-container">
                <h3><i class="fas fa-cloud-upload-alt"></i> Upload Project Media</h3>
                <p class="step-description">Upload images and videos for your project. You can add multiple files.</p>
                
                <div class="upload-zone" id="uploadZone">
                    <div class="upload-placeholder">
                        <i class="fas fa-cloud-upload-alt"></i>
                        <h4>Drop files here or click to browse</h4>
                        <p>Supports JPG, PNG, WebP, MP4, MOV, AVI (Max: 50MB per file)</p>
                    </div>
                    <input type="file" id="fileInput" multiple accept="image/*,video/*" style="display: none;">
                </div>
                
                <div class="uploaded-files" id="uploadedFiles">
                    <!-- Files will be displayed here -->
                </div>
                
                <div class="form-actions">
                    <button type="button" class="btn btn-outline" onclick="prevStep(1)">
                        <i class="fas fa-arrow-left"></i> Previous
                    </button>
                    <button type="button" class="btn btn-primary" onclick="nextStep(3)" id="nextToLayout" disabled>
                        Next: Project Settings <i class="fas fa-arrow-right"></i>
                    </button>
                </div>
            </div>
        </div>

        <!-- Step 3: Project Settings -->
        <div class="wizard-step" id="step3">
            <div class="form-container">
                <h3><i class="fas fa-cog"></i> Project Settings</h3>
                <p class="step-description">Configure your project settings and thumbnail.</p>
                
                <div class="form-grid">
                    <div class="form-group">
                        <label for="aspect_ratio">Default Aspect Ratio</label>
                        <select id="aspect_ratio" name="aspect_ratio">
                            <option value="16:9">16:9 (Landscape)</option>
                            <option value="4:3">4:3 (Standard)</option>
                            <option value="1:1">1:1 (Square)</option>
                            <option value="9:16">9:16 (Portrait)</option>
                            <option value="auto" selected>Auto Detect</option>
                        </select>
                    </div>
                    
                    <div class="form-group">
                        <label for="thumbnail">Project Thumbnail</label>
                        <input type="file" id="thumbnail" name="thumbnail" accept="image/*,video/*">
                        <small>Optional: Custom thumbnail for project listing</small>
                    </div>
                </div>
                
                <div class="thumbnail-preview" id="thumbnailPreview" style="display: none;">
                    <h4>Thumbnail Preview:</h4>
                    <div id="thumbnailPreviewContent"></div>
                </div>
                
                <div class="form-actions">
                    <button type="button" class="btn btn-outline" onclick="prevStep(2)">
                        <i class="fas fa-arrow-left"></i> Previous
                    </button>
                    <button type="submit" class="btn btn-primary" id="createProjectBtn">
                        <i class="fas fa-plus"></i> Create Project
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.project-creation-wizard {
    max-width: 1000px;
    margin: 0 auto;
}

.wizard-step {
    display: none;
}

.wizard-step.active {
    display: block;
    animation: fadeIn 0.5s ease-in;
}

.step-description {
    color: var(--gray-600);
    margin-bottom: 2rem;
    font-size: 1rem;
}

.upload-zone {
    border: 2px dashed var(--gray-300);
    border-radius: 12px;
    padding: 3rem 2rem;
    text-align: center;
    background: var(--gray-50);
    cursor: pointer;
    transition: all 0.3s ease;
    margin-bottom: 2rem;
}

.upload-zone:hover {
    border-color: var(--primary);
    background: var(--gray-100);
}

.upload-zone.dragover {
    border-color: var(--primary);
    background: var(--primary-light);
}

.upload-placeholder i {
    font-size: 3rem;
    color: var(--gray-400);
    margin-bottom: 1rem;
}

.upload-zone:hover .upload-placeholder i {
    color: var(--primary);
}

.uploaded-files {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(200px, 1fr));
    gap: 1rem;
    margin-bottom: 2rem;
}

.file-item {
    background: var(--secondary);
    border: 1px solid var(--gray-200);
    border-radius: 8px;
    padding: 1rem;
    position: relative;
}

.file-preview {
    width: 100%;
    height: 120px;
    object-fit: contain;
    background: #f8f8f8;
    border-radius: 4px;
    margin-bottom: 0.5rem;
}

.file-info {
    font-size: 0.8rem;
    color: var(--gray-600);
}

.file-actions {
    position: absolute;
    top: 0.5rem;
    right: 0.5rem;
}

.remove-file {
    background: var(--error);
    color: var(--secondary);
    border: none;
    border-radius: 50%;
    width: 24px;
    height: 24px;
    cursor: pointer;
    display: flex;
    align-items: center;
    justify-content: center;
}

.thumbnail-preview {
    margin-top: 2rem;
    padding: 1.5rem;
    background: var(--gray-50);
    border-radius: 8px;
    border: 1px solid var(--gray-200);
}

.thumbnail-preview img,
.thumbnail-preview video {
    max-width: 200px;
    max-height: 150px;
    object-fit: contain;
    border-radius: 6px;
}

@keyframes fadeIn {
    from { opacity: 0; transform: translateY(20px); }
    to { opacity: 1; transform: translateY(0); }
}

@media (max-width: 768px) {
    .form-grid {
        grid-template-columns: 1fr;
    }
    
    .uploaded-files {
        grid-template-columns: 1fr;
    }
}
</style>

<script>
let currentStep = 1;
let uploadedFiles = [];

// Step Navigation
function nextStep(step) {
    document.getElementById('step' + currentStep).classList.remove('active');
    document.getElementById('step' + step).classList.add('active');
    currentStep = step;
}

function prevStep(step) {
    document.getElementById('step' + currentStep).classList.remove('active');
    document.getElementById('step' + step).classList.add('active');
    currentStep = step;
}

// File Upload Handling
document.getElementById('uploadZone').addEventListener('click', () => {
    document.getElementById('fileInput').click();
});

document.getElementById('fileInput').addEventListener('change', handleFileSelect);

// Thumbnail preview
document.getElementById('thumbnail').addEventListener('change', function(e) {
    const file = e.target.files[0];
    if (!file) return;
    
    const preview = document.getElementById('thumbnailPreview');
    const previewContent = document.getElementById('thumbnailPreviewContent');
    
    if (file.type.startsWith('image/')) {
        const reader = new FileReader();
        reader.onload = function(e) {
            previewContent.innerHTML = `<img src="${e.target.result}" alt="Thumbnail preview">`;
            preview.style.display = 'block';
        };
        reader.readAsDataURL(file);
    } else if (file.type.startsWith('video/')) {
        previewContent.innerHTML = `
            <video controls style="max-width: 200px; max-height: 150px;">
                <source src="${URL.createObjectURL(file)}" type="${file.type}">
            </video>
            <p><small>Video thumbnail preview</small></p>
        `;
        preview.style.display = 'block';
    }
});

// Drag and Drop
['dragenter', 'dragover', 'dragleave', 'drop'].forEach(eventName => {
    document.getElementById('uploadZone').addEventListener(eventName, preventDefaults, false);
});

function preventDefaults(e) {
    e.preventDefault();
    e.stopPropagation();
}

['dragenter', 'dragover'].forEach(eventName => {
    document.getElementById('uploadZone').addEventListener(eventName, () => {
        document.getElementById('uploadZone').classList.add('dragover');
    }, false);
});

['dragleave', 'drop'].forEach(eventName => {
    document.getElementById('uploadZone').addEventListener(eventName, () => {
        document.getElementById('uploadZone').classList.remove('dragover');
    }, false);
});

document.getElementById('uploadZone').addEventListener('drop', handleDrop);

function handleDrop(e) {
    const dt = e.dataTransfer;
    const files = dt.files;
    handleFiles(files);
}

function handleFileSelect(e) {
    const files = e.target.files;
    handleFiles(files);
}

function handleFiles(files) {
    if (files.length === 0) return;
    
    Array.from(files).forEach((file, index) => {
        // Create a temporary preview
        const fileItem = {
            id: Date.now() + index,
            file: file,
            type: file.type.startsWith('image/') ? 'image' : 'video',
            name: file.name,
            size: file.size,
            url: URL.createObjectURL(file)
        };
        
        uploadedFiles.push(fileItem);
        updateUploadedFilesDisplay();
        
        if (uploadedFiles.length > 0) {
            document.getElementById('nextToLayout').disabled = false;
        }
    });
}

function updateUploadedFilesDisplay() {
    const container = document.getElementById('uploadedFiles');
    container.innerHTML = '';
    
    uploadedFiles.forEach((fileItem, index) => {
        const fileDiv = document.createElement('div');
        fileDiv.className = 'file-item';
        fileDiv.innerHTML = `
            ${fileItem.type === 'image' ? 
                `<img src="${fileItem.url}" class="file-preview" alt="${fileItem.name}">` :
                `<video class="file-preview" controls>
                    <source src="${fileItem.url}" type="video/mp4">
                </video>`
            }
            <div class="file-info">
                <div><strong>${fileItem.name}</strong></div>
                <div>${(fileItem.size / 1024 / 1024).toFixed(2)} MB</div>
            </div>
            <div class="file-actions">
                <button class="remove-file" onclick="removeFile(${index})" type="button">
                    <i class="fas fa-times"></i>
                </button>
            </div>
        `;
        container.appendChild(fileDiv);
    });
}

function removeFile(index) {
    if (confirm('Are you sure you want to remove this file?')) {
        uploadedFiles.splice(index, 1);
        updateUploadedFilesDisplay();
        if (uploadedFiles.length === 0) {
            document.getElementById('nextToLayout').disabled = true;
        }
    }
}

// Form Submission
document.getElementById('createProjectBtn').addEventListener('click', function(e) {
    e.preventDefault();
    
    if (uploadedFiles.length === 0) {
        alert('Please upload at least one media file for your project.');
        return;
    }
    
    // Create FormData
    const formData = new FormData();
    
    // Add basic info
    const basicForm = document.getElementById('basicInfoForm');
    const basicFormData = new FormData(basicForm);
    for (let [key, value] of basicFormData.entries()) {
        formData.append(key, value);
    }
    
    // Add aspect ratio
    formData.append('aspect_ratio', document.getElementById('aspect_ratio').value);
    
    // Add thumbnail
    const thumbnailFile = document.getElementById('thumbnail').files[0];
    if (thumbnailFile) {
        formData.append('thumbnail', thumbnailFile);
    }
    
    // Add media files
    uploadedFiles.forEach((fileItem, index) => {
        formData.append('media_files[]', fileItem.file);
    });
    
    // Show loading state
    const btn = this;
    const originalText = btn.innerHTML;
    btn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Creating Project...';
    btn.disabled = true;
    
    // Submit form
    fetch('<?php echo base_url('admin/projects/add'); ?>', {
        method: 'POST',
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            window.location.href = '<?php echo base_url('admin/projects'); ?>';
        } else {
            alert('Error creating project: ' + data.error);
            btn.innerHTML = originalText;
            btn.disabled = false;
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('Error creating project. Please try again.');
        btn.innerHTML = originalText;
        btn.disabled = false;
    });
});

// Initialize on page load
document.addEventListener('DOMContentLoaded', function() {
    // Add any initialization code here
});
</script>

