

<div class="form-manager">
    <div class="manager-header">
        <div class="header-content">
            <h1 class="content-title">Add Project (Simple)</h1>
            <p class="content-subtitle">Quickly add a project with a single media file. For more options, use the <a href="<?php echo base_url('admin/projects/add-wizard'); ?>" style="color: inherit; text-decoration: underline;">Wizard</a>.</p>
        </div>
        <div class="header-actions">
            <a href="<?php echo base_url('admin/projects'); ?>" class="btn-action btn-outline">
                <i class="fas fa-arrow-left"></i>
                Back to Projects
            </a>
            <a href="<?php echo base_url('admin/projects/add-wizard'); ?>" class="btn-action btn-primary">
                Use Wizard Instead
            </a>
        </div>
    </div>

    <div class="form-card-container">
        <form action="<?php echo base_url('admin/projects/add'); ?>" method="POST" enctype="multipart/form-data" class="modern-form">
            <div class="form-grid-split">
                <!-- Main Info -->
                <div class="form-column">
                    <div class="form-group-modern">
                        <label for="title">Project Title <span class="required-star">*</span></label>
                        <input type="text" id="title" name="title" class="form-control-modern" placeholder="e.g. Summer Campaign 2026" required autofocus>
                    </div>

                    <div class="form-row-modern">
                        <div class="form-group-modern">
                            <label for="client_name">Client Name <span class="required-star">*</span></label>
                            <input type="text" id="client_name" name="client_name" class="form-control-modern" placeholder="e.g. Gucci" required>
                        </div>
                        <div class="form-group-modern">
                            <label for="model_name">Model Name</label>
                            <input type="text" id="model_name" name="model_name" class="form-control-modern" placeholder="Optional">
                        </div>
                    </div>

                    <div class="form-group-modern">
                        <label for="description">Description</label>
                        <textarea id="description" name="description" class="form-control-modern" rows="4" placeholder="Brief description of the project..."></textarea>
                    </div>

                    <div class="form-row-modern">
                        <div class="form-group-modern">
                            <label for="project_size">Grid Size</label>
                            <select id="project_size" name="project_size" class="form-control-modern">
                                <option value="small">Small</option>
                                <option value="medium" selected>Medium</option>
                                <option value="large">Large</option>
                            </select>
                        </div>
                        <div class="form-group-modern">
                            <label for="display_order">Display Order</label>
                            <input type="number" id="display_order" name="display_order" class="form-control-modern" value="0">
                        </div>
                    </div>
                </div>

                <!-- Media -->
                <div class="form-column">
                    <div class="form-group-modern">
                        <label>Main Media File <span class="required-star">*</span></label>
                        <div class="image-upload-zone" id="simpleAddDropZone">
                            <div class="upload-placeholder">
                                <i class="fas fa-photo-video"></i>
                                <p>Click to upload</p>
                                <span>Image or Video (Max 50MB)</span>
                            </div>
                            <input type="file" id="media_file" name="media_file" class="file-input-hidden" accept="image/*,video/*" required>
                        </div>
                    </div>
                </div>
            </div>

            <div class="form-footer-actions">
                <button type="submit" class="btn-action btn-primary">
                    <i class="fas fa-plus"></i>
                    Add Project
                </button>
            </div>
        </form>
    </div>
</div>

<style>
    /* Reusing styles from edit_project.php/add_client.php */
    .manager-header {
        display: flex;
        justify-content: space-between;
        align-items: flex-end;
        margin-bottom: 2.5rem;
    }

    .content-title {
        font-size: 1.75rem;
        font-weight: 800;
        color: #000;
        margin-bottom: 0.25rem;
    }

    .content-subtitle {
        color: #6b7280;
        font-size: 0.95rem;
    }

    .form-card-container {
        background: #fff;
        border-radius: 20px;
        border: 1px solid #e5e7eb;
        padding: 2.5rem;
    }

    .form-grid-split {
        display: grid;
        grid-template-columns: 1.5fr 1fr;
        gap: 3rem;
    }

    .form-group-modern {
        margin-bottom: 1.5rem;
    }

    .form-row-modern {
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 1.5rem;
    }

    .form-group-modern label {
        display: block;
        font-size: 0.9rem;
        font-weight: 600;
        color: #111827;
        margin-bottom: 0.5rem;
    }

    .required-star { color: #ef4444; }

    .form-control-modern {
        width: 100%;
        padding: 0.75rem 1rem;
        background: #f9fafb;
        border: 1px solid #e5e7eb;
        border-radius: 10px;
        font-size: 0.95rem;
        color: #111827;
        transition: all 0.2s;
    }

    .form-control-modern:focus {
        outline: none;
        border-color: #000;
        background: #fff;
        box-shadow: 0 0 0 4px rgba(0,0,0,0.05);
    }

    /* Image Upload Zone */
    .image-upload-zone {
        border: 2px dashed #e5e7eb;
        border-radius: 16px;
        padding: 1.5rem;
        text-align: center;
        background: #f9fafb;
        cursor: pointer;
        transition: all 0.2s;
        position: relative;
        aspect-ratio: 16/9;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .image-upload-zone:hover {
        border-color: #000;
        background: #f3f4f6;
    }

    .upload-placeholder {
        color: #9ca3af;
    }

    .upload-placeholder i {
        font-size: 2.5rem;
        margin-bottom: 1rem;
        color: #d1d5db;
    }

    .upload-placeholder p {
        font-weight: 600;
        color: #4b5563;
        margin-bottom: 0.25rem;
    }

    .upload-placeholder span {
        font-size: 0.75rem;
    }

    .current-image-preview {
        position: relative;
        width: 100%;
        height: 100%;
        border-radius: 12px;
        overflow: hidden;
    }

    .current-image-preview img, .current-image-preview video {
        width: 100%;
        height: 100%;
        object-fit: cover;
    }

    .image-overlay-info {
        position: absolute;
        top: 0.75rem;
        right: 0.75rem;
    }
    
    .badge {
        background: rgba(0,0,0,0.7);
        color: #fff;
        padding: 0.25rem 0.75rem;
        border-radius: 20px;
        font-size: 0.75rem;
        font-weight: 600;
        text-transform: uppercase;
    }

    .file-input-hidden {
        position: absolute;
        top: 0; left: 0; width: 100%; height: 100%;
        opacity: 0;
        cursor: pointer;
    }

    .form-footer-actions {
        margin-top: 3rem;
        padding-top: 2rem;
        border-top: 1px solid #f3f4f6;
        display: flex;
        justify-content: flex-end;
    }

    .btn-action {
        padding: 0.875rem 1.75rem;
        border-radius: 12px;
        font-weight: 700;
        font-size: 0.95rem;
        border: 1px solid transparent;
        cursor: pointer;
        display: inline-flex;
        align-items: center;
        gap: 0.75rem;
        transition: all 0.2s;
        text-decoration: none;
    }

    .btn-primary {
        background: #000;
        color: #fff;
    }

    .btn-primary:hover {
        background: #333;
        transform: translateY(-2px);
        box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1);
    }

    .btn-outline {
        background: transparent;
        border-color: #e5e7eb;
        color: #374151;
    }

    .btn-outline:hover {
        border-color: #000;
        color: #000;
    }
    
    @media (max-width: 900px) {
        .form-grid-split {
            grid-template-columns: 1fr;
            gap: 2rem;
        }
    }
</style>

<script>
    document.getElementById('simpleAddDropZone').addEventListener('click', function() {
        document.getElementById('media_file').click();
    });

    document.getElementById('media_file').addEventListener('change', function(e) {
        if (this.files && this.files[0]) {
            const reader = new FileReader();
            const file = this.files[0];
            const isVideo = file.type.startsWith('video/');
            
            reader.onload = function(ex) {
                const zone = document.getElementById('simpleAddDropZone');
                let content = '';
                
                if (isVideo) {
                    content = `<video src="${ex.target.result}" autoplay muted loop playsinline></video>`;
                } else {
                    content = `<img src="${ex.target.result}" alt="">`;
                }
                
                zone.innerHTML = `
                    <div class="current-image-preview">
                        ${content}
                        <div class="image-overlay-info">
                            <span class="badge">New ${isVideo ? 'Video' : 'Image'}</span>
                        </div>
                    </div>
                `;
            };
            reader.readAsDataURL(file);
        }
    });
</script>

