

<div class="about-manager">
    <div class="manager-header">
        <div class="header-content">
            <h1 class="content-title">About Us Sections</h1>
            <p class="content-subtitle">Tell your studio's story and core philosophy.</p>
        </div>
        <div class="header-actions">
            <a href="<?php echo base_url('admin/about/add'); ?>" class="btn-action btn-primary">
                <i class="fas fa-plus"></i>
                Add Section
            </a>
        </div>
    </div>

    <div class="about-grid">
        <?php if (empty($about_sections)): ?>
            <div class="empty-state-full">
                <i class="fas fa-info-circle"></i>
                <h3>No sections found</h3>
                <p>Create your first segment of the about page.</p>
                <a href="<?php echo base_url('admin/about/add'); ?>" class="btn-action btn-primary">Add Section</a>
            </div>
        <?php else: ?>
            <?php foreach ($about_sections as $section): ?>
                <div class="modern-about-card">
                    <div class="card-image-wrapper">
                        <?php if ($section->image_path): ?>
                            <img src="<?php echo base_url($section->image_path); ?>" alt="">
                        <?php else: ?>
                            <div class="image-placeholder">
                                <i class="fas fa-image"></i>
                                <span>No Image</span>
                            </div>
                        <?php endif; ?>
                        
                        <div class="card-overlay-actions">
                            <a href="<?php echo base_url('admin/about/edit/' . $section->id); ?>" class="overlay-btn edit">
                                <i class="fas fa-pen"></i>
                            </a>
                            <a href="<?php echo base_url('admin/about/delete/' . $section->id); ?>" class="overlay-btn delete" onclick="return confirm('Delete this section?')">
                                <i class="fas fa-trash"></i>
                            </a>
                        </div>
                    </div>
                    
                    <div class="card-body">
                        <div class="card-meta">
                            <span class="order-tag">Order #<?php echo $section->display_order; ?></span>
                        </div>
                        <h3 class="card-title"><?php echo htmlspecialchars($section->title); ?></h3>
                        <div class="card-text">
                            <?php echo nl2br(htmlspecialchars(substr($section->content, 0, 120) . '...')); ?>
                        </div>
                        <?php if ($section->quote): ?>
                            <div class="card-quote">
                                <i class="fas fa-quote-left"></i>
                                <p><?php echo htmlspecialchars($section->quote); ?></p>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endforeach; ?>
        <?php endif; ?>
    </div>
</div>

<style>
    .manager-header {
        display: flex;
        justify-content: space-between;
        align-items: flex-end;
        margin-bottom: 2.5rem;
    }

    .content-title {
        font-size: 1.75rem;
        font-weight: 800;
        color: #000;
        margin-bottom: 0.25rem;
    }

    .content-subtitle {
        color: #6b7280;
        font-size: 0.95rem;
    }

    .about-grid {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(340px, 1fr));
        gap: 2rem;
    }

    .modern-about-card {
        background: #fff;
        border-radius: 20px;
        border: 1px solid #e5e7eb;
        overflow: hidden;
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        display: flex;
        flex-direction: column;
    }

    .modern-about-card:hover {
        transform: translateY(-6px);
        box-shadow: 0 15px 30px -10px rgba(0,0,0,0.1);
        border-color: #d1d5db;
    }

    .card-image-wrapper {
        position: relative;
        aspect-ratio: 16/10;
        background: #f9fafb;
        overflow: hidden;
    }

    .card-image-wrapper img {
        width: 100%;
        height: 100%;
        object-fit: cover;
    }

    .image-placeholder {
        width: 100%;
        height: 100%;
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        color: #d1d5db;
        gap: 0.5rem;
    }

    .image-placeholder i { font-size: 2.5rem; }
    .image-placeholder span { font-size: 0.8rem; font-weight: 600; text-transform: uppercase; }

    .card-overlay-actions {
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: rgba(0,0,0,0.4);
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 1rem;
        opacity: 0;
        transition: opacity 0.2s;
        backdrop-filter: blur(4px);
    }

    .modern-about-card:hover .card-overlay-actions {
        opacity: 1;
    }

    .overlay-btn {
        width: 44px;
        height: 44px;
        border-radius: 50%;
        background: #fff;
        color: #000;
        display: flex;
        align-items: center;
        justify-content: center;
        text-decoration: none;
        font-size: 1.1rem;
        transition: all 0.2s;
    }

    .overlay-btn:hover {
        transform: scale(1.1);
    }

    .overlay-btn.delete:hover {
        background: #ef4444;
        color: #fff;
    }

    .card-body {
        padding: 1.5rem;
        flex: 1;
        display: flex;
        flex-direction: column;
    }

    .card-meta {
        margin-bottom: 0.75rem;
    }

    .order-tag {
        font-size: 0.7rem;
        font-weight: 700;
        text-transform: uppercase;
        letter-spacing: 0.05em;
        color: #9ca3af;
    }

    .card-title {
        font-size: 1.15rem;
        font-weight: 800;
        color: #111827;
        margin-bottom: 0.75rem;
        line-height: 1.3;
    }

    .card-text {
        font-size: 0.9rem;
        line-height: 1.6;
        color: #4b5563;
        margin-bottom: 1.25rem;
    }

    .card-quote {
        margin-top: auto;
        padding: 1rem;
        background: #f9fafb;
        border-radius: 12px;
        position: relative;
    }

    .card-quote i {
        position: absolute;
        top: 0.5rem;
        left: 0.5rem;
        font-size: 0.75rem;
        color: #d1d5db;
    }

    .card-quote p {
        font-size: 0.825rem;
        font-style: italic;
        color: #6b7280;
        padding-left: 0.5rem;
    }

    .empty-state-full {
        grid-column: 1 / -1;
        text-align: center;
        padding: 6rem 2rem;
        color: #d1d5db;
    }

    .empty-state-full i { font-size: 4rem; margin-bottom: 1.5rem; }
</style>

