<?php
class Portfolio_model extends CI_Model {
    
    public function __construct() {
    
        log_message('info', 'Portfolio Model Class Initialized');
    }
    
    // Get all active portfolio items
    public function get_portfolio_items($limit = null, $offset = null) {
        $this->db->select('p.*, c.name as client_name');
        $this->db->from('portfolio_items p');
        $this->db->join('clients c', 'c.id = p.client_id', 'left');
        $this->db->where('p.is_active', 1);
        $this->db->order_by('p.created_at', 'DESC');
        
        if ($limit) {
            $this->db->limit($limit, $offset);
        }
        
        $query = $this->db->get();
        return $query->result();
    }
    
    // Get portfolio item by ID
    public function get_portfolio_item($id) {
        $this->db->select('p.*, c.name as client_name');
        $this->db->from('portfolio_items p');
        $this->db->join('clients c', 'c.id = p.client_id', 'left');
        $this->db->where('p.id', $id);
        $this->db->where('p.is_active', 1);
        $query = $this->db->get();
        return $query->row();
    }
    
    // Add new portfolio item
    public function add_portfolio_item($data) {
        $this->db->insert('portfolio_items', $data);
        return $this->db->insert_id();
    }
    
    // Update portfolio item
    public function update_portfolio_item($id, $data) {
        $this->db->where('id', $id);
        return $this->db->update('portfolio_items', $data);
    }
    
    // Delete portfolio item (soft delete)
    public function delete_portfolio_item($id) {
        $this->db->where('id', $id);
        return $this->db->update('portfolio_items', array('is_active' => 0));
    }
    
    // Get total portfolio count
    public function get_total_portfolio_count() {
        $this->db->where('is_active', 1);
        return $this->db->count_all_results('portfolio_items');
    }
}