<?php
class Enquiry_model extends CI_Model {
    
    public function __construct() {
      log_message('info', 'Enquiry Model Class Initialized');
    }
    
    // Add new enquiry
    public function add_enquiry($data) {
        $this->db->insert('enquiries', $data);
        return $this->db->insert_id();
    }
    
    // Get all enquiries
    public function get_enquiries($limit = null, $offset = null) {
        $this->db->order_by('created_at', 'DESC');
        
        if ($limit) {
            $this->db->limit($limit, $offset);
        }
        
        $query = $this->db->get('enquiries');
        return $query->result();
    }
    
    // Get enquiry by ID
    public function get_enquiry($id) {
        $this->db->where('id', $id);
        $query = $this->db->get('enquiries');
        return $query->row();
    }
    
    // Update enquiry status
    public function update_enquiry_status($id, $status) {
        $this->db->where('id', $id);
        return $this->db->update('enquiries', array('status' => $status));
    }
    
    // Get enquiries count by status
    public function get_enquiries_count($status = null) {
        if ($status) {
            $this->db->where('status', $status);
        }
        return $this->db->count_all_results('enquiries');
    }
}