<?php
class Client_model extends CI_Model {
    
    public function __construct() {
       log_message('info', 'Client Model Class Initialized');
    }
    
    public function get_all_clients() {
        $this->db->order_by('display_order', 'ASC');
        $this->db->order_by('name', 'ASC');
        return $this->db->get('clients')->result();
    }
    
    public function get_active_clients() {
        $this->db->order_by('display_order', 'ASC');
        $this->db->order_by('name', 'ASC');
        $this->db->where('logo IS NOT NULL');
        $this->db->where('logo !=', '');
        return $this->db->get('clients')->result();
    }
    
    public function create_client($data) {
        return $this->db->insert('clients', $data);
    }
    
    public function update_client($id, $data) {
        $this->db->where('id', $id);
        return $this->db->update('clients', $data);
    }
    
    public function delete_client($id) {
        $this->db->where('id', $id);
        return $this->db->delete('clients');
    }
    
    public function get_client($id) {
        $this->db->where('id', $id);
        return $this->db->get('clients')->row();
    }
}