<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class About_model extends CI_Model {
    
    public function __construct() {
      log_message('info', 'About Model Class Initialized');
    }
    
    public function get_about_content() {
        $this->db->where('is_active', 1);
        $this->db->order_by('display_order', 'ASC');
        $this->db->limit(1);
        $query = $this->db->get('about_us');
        return $query->row();
    }
    
    public function get_all_about_sections() {
        $this->db->where('is_active', 1);
        $this->db->order_by('display_order', 'ASC');
        $query = $this->db->get('about_us');
        return $query->result();
    }
    
    public function update_about($id, $data) {
        $this->db->where('id', $id);
        return $this->db->update('about_us', $data);
    }
    
    public function create_about($data) {
        return $this->db->insert('about_us', $data);
    }
    
    public function get_about_by_id($id) {
        $this->db->where('id', $id);
        $query = $this->db->get('about_us');
        return $query->row();
    }
    
    public function delete_about($id) {
        $this->db->where('id', $id);
        return $this->db->delete('about_us');
    }
}
?>