<?php
if (!function_exists('compress_video')) {
    function compress_video($source, $destination, $quality = 'medium') {
        $ffmpeg_path = '/usr/bin/ffmpeg'; // Update this path
        
        $quality_settings = [
            'low' => '-crf 28 -preset slow',
            'medium' => '-crf 23 -preset medium', 
            'high' => '-crf 18 -preset slow'
        ];
        
        $settings = $quality_settings[$quality] ?? $quality_settings['medium'];
        
        $command = "$ffmpeg_path -i $source $settings $destination 2>&1";
        exec($command, $output, $return_code);
        
        return $return_code === 0;
    }
   
function calculateGridSpan($media_path) {
    // Get image dimensions to calculate proper grid span
    $full_path = FCPATH . $media_path;
    
    if (file_exists($full_path)) {
        $image_info = getimagesize($full_path);
        if ($image_info) {
            $width = $image_info[0];
            $height = $image_info[1];
            $aspect_ratio = $height / $width;
            
            // Calculate grid span based on aspect ratio
            if ($aspect_ratio > 1.5) {
                return 50; // Very tall portrait
            } elseif ($aspect_ratio > 1.2) {
                return 45; // Portrait
            } elseif ($aspect_ratio > 0.8) {
                return 35; // Square-ish
            } else {
                return 30; // Landscape
            }
        }
    }
    
    // Default spans for different media types
    return 40; // Default medium height
}

}