<?php
class Portfolio extends CI_Controller {
    
    public function __construct() {
        parent::__construct();
        $this->load->model('Project_model');
        $this->load->model('Client_model');
        $this->load->model('About_model');
        $this->load->model('Contact_model');
        $this->load->helper('url');
    }
    
    public function index() {
        // Fetch Canvas Layout
        // Fetch Canvas Layout
        $this->db->select('homepage_layout.*, projects.title, projects.model_name');
        // Subquery for thumbnail path and type
        $this->db->select('(SELECT media_path FROM project_media WHERE project_media.project_id = projects.id AND project_media.is_thumbnail = 1 LIMIT 1) as thumbnail_path');
        $this->db->select('(SELECT media_type FROM project_media WHERE project_media.project_id = projects.id AND project_media.is_thumbnail = 1 LIMIT 1) as thumbnail_type');
        
        // Subquery for first media if no thumbnail
        $this->db->select('(SELECT media_path FROM project_media WHERE project_media.project_id = projects.id ORDER BY display_order ASC LIMIT 1) as fallback_media');
        $this->db->select('(SELECT media_type FROM project_media WHERE project_media.project_id = projects.id ORDER BY display_order ASC LIMIT 1) as fallback_type');
        
        $data['canvas_layout'] = $this->db->from('homepage_layout')
            ->join('projects', 'projects.id = homepage_layout.project_id')
            ->order_by('homepage_layout.z_index', 'ASC')
            ->get()
            ->result_array();
            
        $data['projects'] = $this->Project_model->get_all_projects();
        // Fetch Canvas Settings
        $data['canvas_height'] = $this->Project_model->get_setting('homepage_canvas_height');
        $data['page'] = 'work';
        $this->load->view('portfolio', $data);
    }
    
    public function project($id) {
        $data['project'] = $this->Project_model->get_project($id);
        $data['project_media'] = $this->Project_model->get_project_media($id);
        
        if (!$data['project']) {
            show_404();
        }
        
        $data['page'] = 'project';
        $this->load->view('project_detail', $data);
    }
    
    public function about() {
        $this->load->model('About_model');
        $data['about'] = $this->About_model->get_about_content();
        $data['page'] = 'about';
        $this->load->view('portfolio/about', $data);
    }
    
    public function clients() {
        $data['clients'] = $this->Client_model->get_active_clients();
        $data['page'] = 'clients';
        $this->load->view('clients', $data);
    }
    
    public function contact() {
        $this->load->model('Contact_model');
        $data['contact_settings'] = $this->Contact_model->get_contact_settings();
        $data['page'] = 'contact';
        $this->load->view('contact', $data);
    }
    
    public function submit_contact() {
        $this->load->model('Contact_model');
        
        header('Content-Type: application/json');
        
        if ($this->input->post()) {
            $inquiry_data = array(
                'name' => $this->input->post('firstName') . ' ' . $this->input->post('lastName'),
                'email' => $this->input->post('email'),
                'phone' => $this->input->post('phone') ?: '',
                'company' => $this->input->post('company') ?: '',
                'subject' => $this->input->post('subject') ?: '',
                'message' => $this->input->post('message'),
                'created_at' => date('Y-m-d H:i:s')
            );
            
            try {
                if ($this->Contact_model->save_inquiry($inquiry_data)) {
                    echo json_encode(['success' => true, 'message' => 'Thank you for your message! We will get back to you soon.']);
                } else {
                    echo json_encode(['success' => false, 'message' => 'Sorry, there was an error saving your message. Please try again.']);
                }
            } catch (Exception $e) {
                error_log('Contact form error: ' . $e->getMessage());
                echo json_encode(['success' => false, 'message' => 'Database error. Please try again.']);
            }
        } else {
            echo json_encode(['success' => false, 'message' => 'Invalid form submission.']);
        }
    }
}
?>