<?php
class Contact extends CI_Controller {
    
    public function __construct() {
        parent::__construct();
        $this->load->model('Contact_model');
        $this->load->library('form_validation');
        $this->load->helper('url');
        $this->load->library('session');
    }
    
    public function submit() {
        $this->form_validation->set_rules('name', 'Name', 'required|min_length[2]|max_length[100]');
        $this->form_validation->set_rules('email', 'Email', 'required|valid_email');
        $this->form_validation->set_rules('message', 'Message', 'required|min_length[10]|max_length[1000]');
        
        if ($this->form_validation->run() == FALSE) {
            $this->session->set_flashdata('error', validation_errors());
        } else {
            $data = array(
                'name' => $this->input->post('name'),
                'email' => $this->input->post('email'),
                'phone' => $this->input->post('phone'),
                'company' => $this->input->post('company'),
                'message' => $this->input->post('message'),
                'created_at' => date('Y-m-d H:i:s')
            );
            
            if ($this->Contact_model->save_inquiry($data)) {
                $this->session->set_flashdata('success', 'Thank you for your message. We will get back to you soon!');
            } else {
                $this->session->set_flashdata('error', 'Sorry, there was an error sending your message. Please try again.');
            }
        }
        
        redirect('contact');
    }
}