<?php
defined('BASEPATH') OR exit('No direct script access allowed');

$route['default_controller'] = 'portfolio';
$route['404_override'] = '';
$route['translate_uri_dashes'] = FALSE;

// Portfolio routes
$route['about'] = 'portfolio/about';
$route['clients'] = 'portfolio/clients';
$route['contact'] = 'portfolio/contact';
$route['project/(:num)'] = 'portfolio/project/$1';

// Contact form submission
$route['contact/submit'] = 'portfolio/submit_contact';
$route['admin/contact-settings'] = 'admin/contact_settings';

// Admin routes
$route['admin'] = 'admin/dashboard';
$route['admin/login'] = 'admin/login';
$route['admin/logout'] = 'admin/logout';
$route['admin/dashboard'] = 'admin/dashboard';
$route['admin/projects'] = 'admin/projects';
$route['admin/projects/add'] = 'admin/add_project';
$route['admin/projects/edit/(:num)'] = 'admin/edit_project/$1';
$route['admin/projects/delete/(:num)'] = 'admin/delete_project/$1';
$route['admin/contact-inquiries'] = 'admin/contact_inquiries';
$route['admin/projects/add-wizard'] = 'admin/add_wizard';
$route['admin/projects/add-wizard/process'] = 'admin/add_project_wizard';

$route['admin/clients'] = 'admin/clients';
$route['admin/clients/add'] = 'admin/add_client';
$route['admin/clients/view/(:num)'] = 'admin/view_client/$1';
$route['admin/clients/edit/(:num)'] = 'admin/edit_client/$1';
$route['admin/clients/update/(:num)'] = 'admin/update_client/$1';
$route['admin/clients/delete/(:num)'] = 'admin/delete_client/$1';
$route['admin/update-homepage-layout'] = 'admin/update_homepage_layout';
$route['admin/projects-enhanced'] = 'admin/add_project_enhanced';
$route['admin/homepage-editor'] = 'admin/homepage_editor';
$route['admin/create_project'] = 'admin/create_project';
$route['admin/upload_temp_media'] = 'admin/upload_temp_media';
$route['admin/remove_temp_media/(:num)'] = 'admin/remove_temp_media/$1';
$route['admin/update_media_layout'] = 'admin/update_media_layout';

// About routes
$route['admin/about'] = 'admin/about';
$route['admin/about/edit/(:num)'] = 'admin/edit_about/$1';
$route['admin/about/add'] = 'admin/add_about_section';